/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.ui.editor2;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.simantics.scl.ui.editor2.SCLModuleSelectionDialog;
import org.simantics.scl.ui.editor2.StandardSCLModuleEditorInput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenSCLModule
extends AbstractHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenSCLModule.class);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        SCLModuleSelectionDialog dialog = new SCLModuleSelectionDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        if (dialog.open() == 0) {
            String moduleName = (String)dialog.getFirstResult();
            OpenSCLModule.scheduleOpenModule(moduleName);
        }
        return null;
    }

    public static Runnable openModule(String moduleName) {
        return () -> {
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            if (page == null) {
                return;
            }
            StandardSCLModuleEditorInput input = new StandardSCLModuleEditorInput(moduleName);
            try {
                page.openEditor((IEditorInput)input, "org.simantics.scl.ui.editor2");
            }
            catch (PartInitException e) {
                LOGGER.error("Could not open module {} ", (Object)moduleName, (Object)e);
            }
        };
    }

    public static void scheduleOpenModule(String moduleName) {
        Display.getCurrent().asyncExec(OpenSCLModule.openModule(moduleName));
    }
}

