/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.common.validation;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.procedure.adapter.TransientCacheAsyncListener;
import org.simantics.db.common.request.RuntimeEnvironmentRequest;
import org.simantics.db.common.utils.CommonDBUtils;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.scl.compiler.runtime.RuntimeEnvironment;
import org.simantics.scl.compiler.types.Type;

public class L0Validations {
    private static RuntimeEnvironment getPossibleRuntimeEnvironment(ReadGraph graph, Resource subject) throws DatabaseException {
        try {
            return (RuntimeEnvironment)graph.syncRequest((Read)new RuntimeEnvironmentRequest(subject), TransientCacheAsyncListener.instance());
        }
        catch (DatabaseException databaseException) {
            return null;
        }
    }

    public static String checkValueType(ReadGraph graph, Resource subject, Resource predicate) throws DatabaseException {
        if (subject == null) {
            return null;
        }
        if (predicate == null) {
            return null;
        }
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        if (graph.isSubrelationOf(predicate, L0.HasProperty)) {
            Resource object = graph.getPossibleObject(subject, predicate);
            if (object == null) {
                return null;
            }
            String valueTypeText = (String)graph.getPossibleRelatedValue(predicate, L0.RequiresValueType, (Binding)Bindings.STRING);
            if (valueTypeText != null) {
                RuntimeEnvironment runtimeEnvironment = L0Validations.getPossibleRuntimeEnvironment(graph, subject);
                if (runtimeEnvironment == null) {
                    return null;
                }
                Type valueType = CommonDBUtils.getSCLType(graph, runtimeEnvironment, valueTypeText);
                if (valueType == null) {
                    Resource range = graph.getPossibleObject(predicate, L0.HasRange);
                    if (range != null) {
                        return null;
                    }
                    StringBuilder sb = new StringBuilder().append("The value type ").append(valueType).append(" of predicate ").append(NameUtils.getSafeName(graph, predicate, true)).append(" cannot be resolved.").append(NameUtils.getSafeName(graph, object, true)).append(".");
                    return sb.toString();
                }
                String valueTypeText2 = (String)graph.getPossibleRelatedValue(object, L0.HasValueType, (Binding)Bindings.STRING);
                if (valueTypeText2 != null) {
                    try {
                        Type valueType2 = CommonDBUtils.getSCLType(graph, subject, valueTypeText2);
                        if (valueType2 == null) {
                            StringBuilder sb = new StringBuilder().append("The value type ").append(valueType2).append(" of object ").append(NameUtils.getSafeName(graph, object, true)).append(" cannot be resolved.");
                            return sb.toString();
                        }
                        if (!valueType.equals((Object)valueType2)) {
                            StringBuilder sb = new StringBuilder().append("The value type ").append(valueType).append(" of predicate ").append(NameUtils.getSafeName(graph, predicate, true)).append(" does not match the value type ").append(valueType2).append(" of object ").append(NameUtils.getSafeName(graph, object, true)).append(".");
                            return sb.toString();
                        }
                    }
                    catch (DatabaseException e) {
                        return e.getMessage();
                    }
                }
            }
        }
        return null;
    }
}

