/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scenegraph.example;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JApplet;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.simantics.utils.threads.AWTThread;
import org.simantics.utils.threads.IThreadWorkQueue;
import org.simantics.utils.threads.ThreadUtils;

public abstract class SWTAWTComponent
extends Composite {
    private Frame frame;
    private Component awtComponent;
    private JApplet panel;
    private final AtomicBoolean populationStarted = new AtomicBoolean(false);
    private final AtomicBoolean populated = new AtomicBoolean(false);
    private final Semaphore populationSemaphore = new Semaphore(0);
    private static AWTEventListener awtListener = null;

    public SWTAWTComponent(Composite parent, int style) {
        super(parent, style | 0x40000 | 0x100000 | 0x1000000);
    }

    private synchronized void initAWTEventListener() {
        if (awtListener == null) {
            awtListener = new AWTEventListener(){

                @Override
                public void eventDispatched(AWTEvent e) {
                    Object src;
                    if (e.getID() == 501 && (src = e.getSource()) instanceof Component) {
                        ((Component)src).requestFocus();
                    }
                }
            };
            ThreadUtils.asyncExec((IThreadWorkQueue)AWTThread.getThreadAccess(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    Toolkit.getDefaultToolkit().addAWTEventListener(awtListener, 16L);
                }
            });
        }
    }

    protected Container getContainer() {
        return this.panel;
    }

    public Component getAWTComponent() {
        return this.awtComponent;
    }

    public void dispose() {
        if (!this.isDisposed()) {
            this.frame.dispose();
            super.dispose();
        }
    }

    public void syncPopulate() {
        this.populate();
        this.waitUntilPopulated();
    }

    public void populate() {
        if (!this.populationStarted.compareAndSet(false, true)) {
            throw new IllegalStateException(String.valueOf((Object)this) + ".populate was invoked multiple times");
        }
        this.checkWidget();
        this.createFrame();
        this.scheduleComponentCreation();
    }

    public void waitUntilPopulated() {
        if (this.populated.get()) {
            return;
        }
        try {
            boolean done = false;
            while (!done) {
                done = this.populationSemaphore.tryAcquire(10L, TimeUnit.MILLISECONDS);
                while (!done && this.getDisplay().readAndDispatch()) {
                    if (this.isDisposed()) {
                        return;
                    }
                    done = this.populationSemaphore.tryAcquire();
                }
            }
        }
        catch (InterruptedException e) {
            throw new Error("EmbeddedSwingComposite population interrupted for class " + String.valueOf((Object)this), e);
        }
    }

    private void createFrame() {
        System.setProperty("sun.awt.noerasebackground", "true");
        if (this.frame == null) {
            this.frame = SWT_AWT.new_Frame((Composite)this);
        }
        this.addControlListener((ControlListener)new CleanResizeListener());
        this.initAWTEventListener();
    }

    private void scheduleComponentCreation() {
        ThreadUtils.asyncExec((IThreadWorkQueue)AWTThread.getThreadAccess(), (Runnable)new Runnable(){

            @Override
            public void run() {
                SWTAWTComponent.this.panel = new JApplet();
                SWTAWTComponent.this.panel.setLayout(new GridLayout(1, 1, 0, 0));
                SWTAWTComponent.this.frame.add(SWTAWTComponent.this.panel);
                try {
                    SWTAWTComponent.this.awtComponent = SWTAWTComponent.this.createSwingComponent();
                    SWTAWTComponent.this.panel.add(SWTAWTComponent.this.awtComponent);
                }
                finally {
                    SWTAWTComponent.this.populated.set(true);
                    if (SWTAWTComponent.this.populationSemaphore != null) {
                        SWTAWTComponent.this.populationSemaphore.release();
                    }
                }
            }
        });
    }

    protected abstract Component createSwingComponent();

    private static class CleanResizeListener
    extends ControlAdapter {
        private Rectangle oldRect = null;

        private CleanResizeListener() {
        }

        public void controlResized(ControlEvent e) {
            assert (e != null);
            assert (Display.getCurrent() != null);
            Composite composite = (Composite)e.widget;
            Rectangle newRect = composite.getClientArea();
            if (this.oldRect != null) {
                int heightDelta = newRect.height - this.oldRect.height;
                int widthDelta = newRect.width - this.oldRect.width;
                if (heightDelta > 0 || widthDelta > 0) {
                    GC gc = new GC((Drawable)composite);
                    try {
                        gc.fillRectangle(newRect.x, this.oldRect.height, newRect.width, heightDelta);
                        gc.fillRectangle(this.oldRect.width, newRect.y, widthDelta, newRect.height);
                    }
                    finally {
                        gc.dispose();
                    }
                }
            }
            this.oldRect = newRect;
        }
    }
}

