/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.platform.ui;

import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

public class SimanticsConsole
extends MessageConsole {
    private static int HIGH_WATERMARK = 524288;
    private static int LOW_WATERMARK = 3 * (HIGH_WATERMARK >> 2);
    private ExecutorService executor = Executors.newSingleThreadExecutor();
    private Color black;
    private Color red;
    private Color green;
    private Color yellow;
    private Color blue;
    private Color magenta;
    private Color cyan;
    private Color white;
    private MessageConsoleStream stream;

    public SimanticsConsole() {
        super("Simantics Console", "Simantics Console", null, true);
    }

    protected void init() {
        Display d = Display.getDefault();
        this.black = this.tuneColor(d, 2);
        this.red = this.tuneColor(d, 3);
        this.green = this.tuneColor(d, 5);
        this.yellow = this.tuneColor(d, 7);
        this.blue = this.tuneColor(d, 9);
        this.magenta = this.tuneColor(d, 11);
        this.cyan = this.tuneColor(d, 13);
        this.white = this.tuneColor(d, 1);
        this.setBackground(this.black);
        this.stream = this.newMessageStream();
        this.stream.setFontStyle(0);
        this.stream.setColor(this.white);
        this.setWaterMarks(LOW_WATERMARK, HIGH_WATERMARK);
    }

    protected void dispose() {
        super.dispose();
        this.executor.shutdown();
        this.executor = null;
        this.stream = null;
        this.black.dispose();
        this.red.dispose();
        this.green.dispose();
        this.yellow.dispose();
        this.blue.dispose();
        this.magenta.dispose();
        this.cyan.dispose();
        this.white.dispose();
    }

    private Color tuneColor(Display d, int color) {
        Color c = d.getSystemColor(color);
        return new Color((Device)d, (int)((double)c.getRed() * 0.75), (int)((double)c.getGreen() * 0.75), (int)((double)c.getBlue() * 0.75));
    }

    public static SimanticsConsole show() {
        if (!Thread.currentThread().equals(Display.getDefault().getThread())) {
            Display.getDefault().asyncExec(() -> {
                SimanticsConsole simanticsConsole = SimanticsConsole.show();
            });
            return null;
        }
        IConsole[] iConsoleArray = ConsolePlugin.getDefault().getConsoleManager().getConsoles();
        int n = iConsoleArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConsole c = iConsoleArray[n2];
            if (c instanceof SimanticsConsole) {
                SimanticsConsole sc = (SimanticsConsole)c;
                sc.activate();
                return sc;
            }
            ++n2;
        }
        SimanticsConsole sc = new SimanticsConsole();
        ConsolePlugin.getDefault().getConsoleManager().addConsoles((IConsole[])new SimanticsConsole[]{sc});
        sc.activate();
        return sc;
    }

    public static SimanticsConsole findConsole() {
        IConsole[] iConsoleArray = ConsolePlugin.getDefault().getConsoleManager().getConsoles();
        int n = iConsoleArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConsole c = iConsoleArray[n2];
            if (c instanceof SimanticsConsole) {
                return (SimanticsConsole)c;
            }
            ++n2;
        }
        SimanticsConsole sc = new SimanticsConsole();
        ConsolePlugin.getDefault().getConsoleManager().addConsoles((IConsole[])new SimanticsConsole[]{sc});
        return sc;
    }

    public void write(String data) {
        this.executor.submit(() -> {
            Pattern p = Pattern.compile("(\\x1b\\[(?<cmd>.*?(m)))");
            Matcher m = p.matcher(data);
            int pos = 0;
            while (m.find()) {
                if (m.start() > pos) {
                    this.stream.print(data.substring(pos, m.start()));
                }
                pos = m.end();
                String cmd = m.group("cmd");
                if (!cmd.endsWith("m")) continue;
                Display.getDefault().syncExec(() -> {
                    String[] attributes;
                    int fontStyle = this.stream.getFontStyle();
                    Color color = this.stream.getColor();
                    try {
                        this.stream.close();
                    }
                    catch (IOException iOException) {}
                    this.stream = this.newMessageStream();
                    String[] stringArray = attributes = cmd.substring(0, cmd.length() - 1).split(";");
                    int n = attributes.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String attribute = stringArray[n2];
                        switch (Integer.parseInt(attribute)) {
                            case 0: {
                                fontStyle = 0;
                                break;
                            }
                            case 1: {
                                fontStyle = 1;
                                break;
                            }
                            case 4: {
                                break;
                            }
                            case 5: {
                                break;
                            }
                            case 7: {
                                break;
                            }
                            case 8: {
                                break;
                            }
                            case 30: {
                                color = this.black;
                                break;
                            }
                            case 31: {
                                color = this.red;
                                break;
                            }
                            case 32: {
                                color = this.green;
                                break;
                            }
                            case 33: {
                                color = this.yellow;
                                break;
                            }
                            case 34: {
                                color = this.blue;
                                break;
                            }
                            case 35: {
                                color = this.magenta;
                                break;
                            }
                            case 36: {
                                color = this.cyan;
                                break;
                            }
                            case 37: {
                                color = this.white;
                                break;
                            }
                        }
                        ++n2;
                    }
                    this.stream.setColor(color);
                    this.stream.setFontStyle(fontStyle);
                });
            }
            if (pos < data.length()) {
                this.stream.print(data.substring(pos));
            }
            this.stream.println();
        });
    }
}

