/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.graph.compiler.internal.templates;

import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.Arrays;
import java.util.Collection;
import org.simantics.graph.compiler.ExternalFileLoader;
import org.simantics.graph.compiler.internal.ltk.Location;
import org.simantics.graph.compiler.internal.ltk.Problem;
import org.simantics.graph.compiler.internal.store.LocationStore;
import org.simantics.graph.compiler.internal.templates.ITemplate;
import org.simantics.graph.query.IGraph;
import org.simantics.graph.representation.External;
import org.simantics.graph.representation.Identity;
import org.simantics.graph.representation.Root;
import org.simantics.graph.representation.TransferableGraph1;
import org.simantics.graph.representation.Value;
import org.simantics.graph.store.GraphStore;
import org.simantics.graph.store.IdentityStore;
import org.simantics.graph.store.StatementStore;
import org.simantics.graph.store.ValueStore;

public class GraphTemplate
implements ITemplate {
    int[] prototypeResources;
    int[] parameterMapping;
    int[] statements;
    Value[] values;

    public GraphTemplate(GraphStore store, String[] parameters, TransferableGraph1 tg) {
        this.prototypeResources = new int[tg.resourceCount];
        Arrays.fill(this.prototypeResources, -1);
        this.values = tg.values;
        this.statements = tg.statements;
        this.parameterMapping = new int[parameters.length];
        TObjectIntHashMap pmap = new TObjectIntHashMap();
        int i = 0;
        while (i < parameters.length) {
            pmap.put((Object)parameters[i], i);
            ++i;
        }
        Identity[] identityArray = tg.identities;
        int n = tg.identities.length;
        int n2 = 0;
        while (n2 < n) {
            Identity id = identityArray[n2];
            if (id.definition instanceof Root) {
                def = (Root)id.definition;
                if (pmap.containsKey((Object)def.name)) {
                    this.parameterMapping[pmap.get((Object)def.name)] = id.resource;
                } else {
                    this.prototypeResources[id.resource] = store.identities.getRoot(def.name);
                }
            } else if (id.definition instanceof External) {
                def = (External)id.definition;
                this.prototypeResources[id.resource] = store.identities.getChild(this.prototypeResources[def.parent], def.name);
            } else {
                throw new RuntimeException("Invalid template");
            }
            ++n2;
        }
    }

    @Override
    public void apply(IGraph graph, GraphStore store, int[] parameters, ExternalFileLoader fileLoader, Collection<Problem> problems) {
        if (parameters.length != this.parameterMapping.length) {
            Location location = ((LocationStore)store.getStore(LocationStore.class)).getLocation(parameters[0]);
            problems.add(new Problem(location, "A template applied with wrong number of parameters."));
            return;
        }
        int[] resources = Arrays.copyOf(this.prototypeResources, this.prototypeResources.length);
        int i = 0;
        while (i < this.parameterMapping.length) {
            resources[this.parameterMapping[i]] = parameters[i];
            ++i;
        }
        IdentityStore identities = store.identities;
        int i2 = 0;
        while (i2 < resources.length) {
            if (resources[i2] < 0) {
                resources[i2] = identities.newResource();
            }
            ++i2;
        }
        StatementStore statementStore = store.statements;
        int i3 = 0;
        while (i3 < this.statements.length) {
            statementStore.add(resources[this.statements[i3]], resources[this.statements[i3 + 1]], resources[this.statements[i3 + 3]]);
            i3 += 4;
        }
        ValueStore valueStore = store.values;
        Value[] valueArray = this.values;
        int n = this.values.length;
        int n2 = 0;
        while (n2 < n) {
            Value value = valueArray[n2];
            valueStore.setValue(resources[value.resource], value.value);
            ++n2;
        }
    }

    public void map(TIntIntHashMap map) {
        int i = 0;
        while (i < this.prototypeResources.length) {
            int temp = this.prototypeResources[i];
            if (temp >= 0 && map.contains(temp)) {
                this.prototypeResources[i] = map.get(temp);
            }
            ++i;
        }
    }
}

