/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.annotation.ui;

import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.simantics.Simantics;
import org.simantics.annotation.ontology.AnnotationResource;
import org.simantics.annotation.ui.Activator;
import org.simantics.annotation.ui.AnnotationUtils;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.util.URIStringUtils;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.VirtualGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.layer0.util.RemoverUtil;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.VariableBuilder;
import org.simantics.db.layer0.variable.VariableMap;
import org.simantics.db.layer0.variable.VariableMapImpl;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.db.request.WriteInterface;
import org.simantics.db.service.VirtualGraphSupport;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.ModelingUtils;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.loader.ScenegraphLoaderUtils;
import org.simantics.scenegraph.utils.NodeUtil;
import org.simantics.scl.reflection.annotations.SCLValue;
import org.simantics.scl.runtime.function.FunctionImpl1;
import org.simantics.scl.runtime.tuple.Tuple;
import org.simantics.scl.runtime.tuple.Tuple2;
import org.simantics.scl.runtime.tuple.Tuple3;
import org.simantics.utils.datastructures.Pair;
import org.simantics.utils.strings.AlphanumComparator;
import org.simantics.utils.ui.ISelectionUtils;
import org.simantics.views.swt.client.base.ISWTViewNode;
import org.simantics.views.swt.client.impl.SWTExplorer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SCL {
    private static final Logger LOGGER = LoggerFactory.getLogger(SCL.class);
    public static final String EMPTY = "";
    public static final String MAPPED = "Mapped";
    public static final String SELECTED = "Selected";
    public static final String NO_ANNOTATIONS = "No annotations";
    private static final Comparator<? super Tuple3> AVAILABLE_ANNOTATION_SORTER = new Comparator<Tuple3>(){

        @Override
        public int compare(Tuple3 o1, Tuple3 o2) {
            String s1 = (String)o1.c2;
            String s2 = (String)o2.c2;
            return AlphanumComparator.CASE_INSENSITIVE_COMPARATOR.compare((Object)s1, (Object)s2);
        }
    };
    @SCLValue(type="VariableMap")
    public static VariableMap domainChildren = new VariableMapImpl(){

        private Map<String, Resource> children(ReadGraph graph, Resource resource) throws DatabaseException {
            AnnotationResource ANNO = AnnotationResource.getInstance((ReadGraph)graph);
            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            Collection objects = graph.getObjects(resource, ANNO.Annotation_HasEntry);
            THashMap result = new THashMap(objects.size());
            for (Resource r : objects) {
                String name = (String)graph.getPossibleRelatedValue(r, L0.HasName, (Binding)Bindings.STRING);
                if (name == null || result.put((Object)name, (Object)r) == null) continue;
                LOGGER.error("The database contains siblings with the same name " + name + " (resource=$" + resource.getResourceId() + ").");
            }
            return result;
        }

        public Variable getVariable(ReadGraph graph, Variable context, String name) throws DatabaseException {
            Map<String, Resource> children = this.children(graph, context.getRepresents(graph));
            Resource child = children.get(name);
            if (child == null) {
                return null;
            }
            VariableBuilder variableBuilder = (VariableBuilder)graph.adapt(child, VariableBuilder.class);
            return variableBuilder.buildChild(graph, context, null, child);
        }

        public Map<String, Variable> getVariables(ReadGraph graph, Variable context, Map<String, Variable> map) throws DatabaseException {
            Map<String, Resource> childMap = this.children(graph, context.getRepresents(graph));
            if (childMap.isEmpty()) {
                return map;
            }
            if (map == null) {
                map = new THashMap();
            }
            for (Map.Entry<String, Resource> entry : childMap.entrySet()) {
                String name = entry.getKey();
                Resource child = entry.getValue();
                VariableBuilder variableBuilder = (VariableBuilder)graph.adapt(child, VariableBuilder.class);
                Variable var = variableBuilder.buildChild(graph, context, null, child);
                if (var != null) {
                    map.put(name, var);
                    continue;
                }
                LOGGER.warn("No adapter for " + String.valueOf(child) + " in " + context.getURI(graph));
            }
            return map;
        }
    };

    @SCLValue(type="ReadGraph -> Resource -> Variable -> [(String, Resource)]")
    public static List<Tuple> availableSources(ReadGraph graph, Resource resource, Variable context) throws DatabaseException {
        Variable selection = ScenegraphLoaderUtils.getPossibleVariableSelection((ReadGraph)graph, (Variable)context);
        if (selection == null) {
            return Collections.emptyList();
        }
        List<Tuple3> sources = SCL.availableSourcesImpl(graph, selection);
        if (sources.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Tuple> result = new ArrayList<Tuple>(sources.size());
        for (Tuple3 anno : sources) {
            result.add((Tuple)new Tuple2(anno.get(0), (Object)EMPTY));
        }
        return result;
    }

    private static List<Tuple3> availableSourcesImpl(ReadGraph graph, Variable selection) throws DatabaseException {
        List<Variable> vars = SCL.gatherSourceVariables(graph, selection);
        if (vars.isEmpty()) {
            return Collections.emptyList();
        }
        int size = vars.size();
        ArrayList<Tuple3> result = new ArrayList<Tuple3>(size);
        result.add(new Tuple3((Object)SCL.sourceLabel(graph, vars.get(0)), (Object)SELECTED, (Object)vars.get(0)));
        int i = 1;
        while (i < size) {
            Variable v = vars.get(i);
            result.add(new Tuple3((Object)SCL.sourceLabel(graph, v), (Object)MAPPED, (Object)v));
            ++i;
        }
        return result;
    }

    private static List<Variable> gatherSourceVariables(ReadGraph graph, Variable source) throws DatabaseException {
        Resource represents = source.getPossibleRepresents(graph);
        if (represents == null) {
            return Collections.singletonList(source);
        }
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        ArrayList<Variable> result = new ArrayList<Variable>(4);
        HashSet<Resource> visited = new HashSet<Resource>();
        for (Resource r : ModelingUtils.getElementCorrespondendences((ReadGraph)graph, (Resource)represents)) {
            SCL.addPossibleVariable(graph, r, visited, result);
        }
        for (Resource r : graph.getObjects(represents, MOD.DiagramToComposite)) {
            SCL.addPossibleVariable(graph, r, visited, result);
        }
        result.add(source);
        for (Resource r : graph.getObjects(represents, MOD.ComponentToElement)) {
            SCL.addPossibleVariable(graph, r, visited, result);
        }
        for (Resource r : graph.getObjects(represents, MOD.CompositeToDiagram)) {
            SCL.addPossibleVariable(graph, r, visited, result);
        }
        return result;
    }

    private static void addPossibleVariable(ReadGraph graph, Resource r, Set<Resource> visited, List<Variable> result) throws DatabaseException {
        Variable v;
        if (visited.add(r) && (v = Variables.getPossibleVariable((ReadGraph)graph, (Resource)r)) != null) {
            result.add(v);
        }
    }

    private static String sourceLabel(ReadGraph graph, Variable variable) throws DatabaseException {
        Resource represents = variable.getPossibleRepresents(graph);
        if (represents != null) {
            DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
            if (graph.isInstanceOf(represents, DIA.Diagram)) {
                return "Diagram";
            }
            if (graph.isInstanceOf(represents, DIA.Flag)) {
                return "Flag Element";
            }
            if (graph.isInstanceOf(represents, DIA.RouteGraphConnection)) {
                return "Connection Element";
            }
            if (graph.isInstanceOf(represents, DIA.Monitor)) {
                return "Monitor Element";
            }
            if (graph.isInstanceOf(represents, DIA.Element)) {
                return "Diagram Element";
            }
            return variable.getName(graph);
        }
        return variable.getURI(graph);
    }

    private static <T> T selectedSource(ReadGraph graph, Variable selection) throws DatabaseException {
        String name = SCL.selectedSourceName(graph, selection);
        for (Tuple tuple : SCL.availableSourcesImpl(graph, selection)) {
            if (!tuple.get(1).equals(name)) continue;
            return (T)tuple.get(2);
        }
        return null;
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> String")
    public static String selectedSource(ReadGraph graph, Resource resource, Variable context) throws DatabaseException {
        Variable selection = ScenegraphLoaderUtils.getVariableSelection((ReadGraph)graph, (Variable)context);
        String name = SCL.selectedSourceName(graph, selection);
        for (Tuple tuple : SCL.availableSourcesImpl(graph, selection)) {
            if (!tuple.get(1).equals(name)) continue;
            return (String)tuple.get(0);
        }
        return EMPTY;
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> a")
    public static Object selectedSourceModifier(ReadGraph graph, Resource resource, final Variable context) throws DatabaseException {
        return new FunctionImpl1<Object, Object>(){

            public Object apply(Object sourceKey) {
                try {
                    Session s = Simantics.getSession();
                    VirtualGraph vg = ((VirtualGraphSupport)s.getService(VirtualGraphSupport.class)).getWorkspacePersistent("preferences");
                    s.syncRequest((Write)new SetDefaultAnnotationSourceRequest(vg, context, sourceKey));
                }
                catch (DatabaseException e) {
                    Activator.getDefault().getLog().log((IStatus)new Status(4, "org.simantics.annotation.ui", "Failed to update default annotation source, see exception for details.", (Throwable)e));
                }
                return null;
            }
        };
    }

    private static Collection<Tuple3> availableAnnotationsImpl(ReadGraph graph, Variable selection) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        AnnotationResource ANNO = AnnotationResource.getInstance((ReadGraph)graph);
        HashSet<Resource> processed = new HashSet<Resource>();
        selection = (Variable)SCL.selectedSource(graph, selection);
        ArrayList<Tuple3> result = new ArrayList<Tuple3>();
        for (Variable child : selection.getChildren(graph)) {
            String name;
            Resource represents = child.getPossibleRepresents(graph);
            if (represents == null || !graph.isInstanceOf(represents, ANNO.Annotation) || !processed.add(represents) || (name = (String)graph.getPossibleRelatedValue(represents, L0.HasName)) == null) continue;
            result.add(new Tuple3((Object)child, (Object)represents, (Object)name));
        }
        for (Variable property : selection.getProperties(graph)) {
            Resource propertyResource = property.getPossibleRepresents(graph);
            if (propertyResource == null || !graph.isInstanceOf(propertyResource, ANNO.Annotation) || !processed.add(propertyResource)) continue;
            String propertyName = property.getName(graph);
            result.add(new Tuple3((Object)property, (Object)propertyResource, (Object)propertyName));
        }
        Collections.sort(result, AVAILABLE_ANNOTATION_SORTER);
        return result;
    }

    private static Pair<Resource, String> defaultAnnotationTypeAndName(ReadGraph graph, Variable selection) throws DatabaseException {
        AnnotationResource ANNO = AnnotationResource.getInstance((ReadGraph)graph);
        Resource model = Variables.getPossibleIndexRoot((ReadGraph)graph, (Variable)selection);
        Resource type = graph.getPossibleObject(model, ANNO.HasDefaultAnnotationType);
        String name = (String)graph.getPossibleRelatedValue(model, ANNO.HasDefaultAnnotationName, (Binding)Bindings.STRING);
        return Pair.make((Object)type, (Object)name);
    }

    private static String selectedAnnotationName(ReadGraph graph, Variable selection) throws DatabaseException {
        Pair<Resource, String> typeAndName = SCL.defaultAnnotationTypeAndName(graph, selection);
        Collection<Tuple3> available = SCL.availableAnnotationsImpl(graph, selection);
        if (!available.isEmpty()) {
            if (available.size() == 1 || typeAndName.first == null) {
                return (String)available.iterator().next().c2;
            }
            String firstTypeMatch = null;
            for (Tuple3 anno : available) {
                if (!graph.isInstanceOf((Resource)anno.c1, (Resource)typeAndName.first)) continue;
                if (firstTypeMatch == null) {
                    firstTypeMatch = (String)anno.c2;
                }
                if (typeAndName.second == null || !((String)typeAndName.second).equals(anno.c2)) continue;
                return (String)anno.c2;
            }
            if (firstTypeMatch != null) {
                return firstTypeMatch;
            }
            return (String)available.iterator().next().c2;
        }
        return NO_ANNOTATIONS;
    }

    private static String selectedSourceName(ReadGraph graph, Variable selection) throws DatabaseException {
        AnnotationResource ANNO = AnnotationResource.getInstance((ReadGraph)graph);
        Resource model = Variables.getPossibleIndexRoot((ReadGraph)graph, (Variable)selection);
        if (model == null) {
            return EMPTY;
        }
        String name = (String)graph.getPossibleRelatedValue(model, ANNO.DefaultAnnotationSource, (Binding)Bindings.STRING);
        if (name != null) {
            for (Tuple tuple : SCL.availableSourcesImpl(graph, selection)) {
                if (!tuple.get(1).equals(name)) continue;
                return name;
            }
        }
        THashSet tHashSet = new THashSet();
        for (Tuple tuple : SCL.availableSourcesImpl(graph, selection)) {
            tHashSet.add((String)tuple.get(1));
        }
        if (tHashSet.isEmpty()) {
            return EMPTY;
        }
        if (tHashSet.contains(MAPPED)) {
            return MAPPED;
        }
        return (String)tHashSet.iterator().next();
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> a")
    public static Object explorerInput(ReadGraph graph, Resource resource, Variable context) throws DatabaseException {
        Variable selection = ScenegraphLoaderUtils.getVariableSelection((ReadGraph)graph, (Variable)context);
        String selected = SCL.selectedAnnotationName(graph, selection);
        for (Tuple3 anno : SCL.availableAnnotationsImpl(graph, selection)) {
            if (!selected.equals(anno.c2)) continue;
            return anno.c0;
        }
        return null;
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> String")
    public static String descriptionText(ReadGraph graph, Resource resource, Variable context) throws DatabaseException {
        Object result = EMPTY;
        Variable sel = SCL.getSelectedAnnotationVariable(graph, context);
        if (sel != null) {
            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            Resource literal = sel.getPossibleRepresents(graph);
            if (literal != null) {
                Resource container = graph.getPossibleObject(literal, L0.PartOf);
                if (container != null) {
                    Resource model = Variables.getPossibleIndexRoot((ReadGraph)graph, (Variable)sel);
                    String modelURI = graph.getURI(model);
                    String path = graph.getURI(literal);
                    if (path.startsWith(modelURI)) {
                        path = path.substring(modelURI.length() + 1);
                    }
                    result = (String)result + URIStringUtils.unescape((String)path);
                } else {
                    result = (String)result + "The annotation is not attached to a library";
                }
            }
        }
        return result;
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> a")
    public static Object explorerInput2(ReadGraph graph, Resource resource, Variable context) throws DatabaseException {
        return ScenegraphLoaderUtils.getVariableSelection((ReadGraph)graph, (Variable)context);
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> [(String, Resource)]")
    public static List<Tuple> availableAnnotations(ReadGraph graph, Resource resource, Variable context) throws DatabaseException {
        Variable selection = ScenegraphLoaderUtils.getVariableSelection((ReadGraph)graph, (Variable)context);
        ArrayList<Tuple> result = new ArrayList<Tuple>();
        for (Tuple3 anno : SCL.availableAnnotationsImpl(graph, selection)) {
            result.add((Tuple)new Tuple2(anno.c2, anno.c1));
        }
        if (result.isEmpty()) {
            result.add((Tuple)new Tuple2((Object)NO_ANNOTATIONS, (Object)EMPTY));
        }
        return result;
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> String")
    public static String selectedAnnotation(ReadGraph graph, Resource resource, Variable context) throws DatabaseException {
        Variable selection = ScenegraphLoaderUtils.getVariableSelection((ReadGraph)graph, (Variable)context);
        return SCL.selectedAnnotationName(graph, selection);
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> a")
    public static Object selectedAnnotationModifier(ReadGraph graph, Resource resource, final Variable context) throws DatabaseException {
        return new FunctionImpl1<Object, Object>(){

            public Object apply(final Object _key) {
                Session s = Simantics.getSession();
                VirtualGraph vg = ((VirtualGraphSupport)s.getService(VirtualGraphSupport.class)).getWorkspacePersistent("preferences");
                s.async((WriteInterface)new WriteRequest(vg){

                    public void perform(WriteGraph graph) throws DatabaseException {
                        AnnotationResource ANNO = AnnotationResource.getInstance((ReadGraph)graph);
                        String key = (String)_key;
                        Variable selection = ScenegraphLoaderUtils.getVariableSelection((ReadGraph)graph, (Variable)context);
                        for (Tuple3 anno : SCL.availableAnnotationsImpl((ReadGraph)graph, selection)) {
                            if (!key.equals(anno.c2)) continue;
                            Resource type = graph.getPossibleType((Resource)anno.c1, ANNO.Annotation);
                            Resource model = Variables.getPossibleIndexRoot((ReadGraph)graph, (Variable)selection);
                            graph.deny(model, ANNO.HasDefaultAnnotationType);
                            graph.claim(model, ANNO.HasDefaultAnnotationType, type);
                            graph.denyValue(model, ANNO.HasDefaultAnnotationName);
                            graph.claimLiteral(model, ANNO.HasDefaultAnnotationName, (Object)key, (Binding)Bindings.STRING);
                            break;
                        }
                    }
                });
                return null;
            }
        };
    }

    private static Resource getSelectionResource(Variable context) throws DatabaseException {
        return (Resource)Simantics.getSession().syncRequest((Read)new UnaryRead<Variable, Resource>(context){

            public Resource perform(ReadGraph graph) throws DatabaseException {
                Variable selection = ScenegraphLoaderUtils.getVariableSelection((ReadGraph)graph, (Variable)((Variable)this.parameter));
                Variable source = (Variable)SCL.selectedSource(graph, selection);
                return source.getPossibleRepresents(graph);
            }
        });
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> a")
    public static Object newAnnotationModifier(ReadGraph graph, Resource resource, Variable context) throws DatabaseException {
        return new AddModifier(context);
    }

    private static Variable getSelectedAnnotationVariable(ReadGraph graph, Variable context) throws DatabaseException {
        Variable selection = ScenegraphLoaderUtils.getVariableSelection((ReadGraph)graph, (Variable)context);
        String selected = SCL.selectedAnnotationName(graph, selection);
        for (Tuple3 anno : SCL.availableAnnotationsImpl(graph, selection)) {
            if (!anno.c2.equals(selected)) continue;
            return (Variable)anno.c0;
        }
        return null;
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> a")
    public static Object removeAnnotationModifier(ReadGraph graph, Resource resource, Variable context) throws DatabaseException {
        return new RemoveModifier();
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> a")
    public static Object saveAnnotationModifier(ReadGraph graph, Resource resource, Variable context) throws DatabaseException {
        return new SaveModifier();
    }

    static class AddModifier
    extends FunctionImpl1<Object, Object> {
        private final Variable context;

        public AddModifier(Variable context) {
            this.context = context;
        }

        private void doAdd(Variable variable) throws DatabaseException {
            if (variable != null) {
                AnnotationUtils.newAnnotation(variable);
            } else {
                Resource parent = SCL.getSelectionResource(this.context);
                if (parent != null) {
                    AnnotationUtils.newAnnotation(parent);
                }
            }
        }

        public Object apply(Object p0) {
            ISWTViewNode node = (ISWTViewNode)p0;
            SWTExplorer properties = (SWTExplorer)NodeUtil.browsePossible((INode)node, (String)"./Properties");
            if (properties == null) {
                return null;
            }
            try {
                this.doAdd((Variable)properties.input);
            }
            catch (DatabaseException e) {
                LOGGER.error("newAnnotationModifier failed", (Throwable)e);
            }
            return null;
        }
    }

    static class RemoveModifier
    extends FunctionImpl1<Object, Object> {
        RemoveModifier() {
        }

        private boolean doRemove(final Variable variable) {
            if (!AnnotationUtils.isAnnotation(variable)) {
                return false;
            }
            Simantics.getSession().async((WriteInterface)new WriteRequest(){

                public void perform(WriteGraph graph) throws DatabaseException {
                    graph.markUndoPoint();
                    Resource represents = variable.getPossibleRepresents((ReadGraph)graph);
                    if (represents != null) {
                        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                        AnnotationResource ANNO = AnnotationResource.getInstance((ReadGraph)graph);
                        if (graph.isInstanceOf(represents, ANNO.Annotation)) {
                            Resource subject = variable.getParent((ReadGraph)graph).getRepresents((ReadGraph)graph);
                            Resource predicate = variable.getPossiblePredicateResource((ReadGraph)graph);
                            if (predicate != null) {
                                graph.deny(subject, predicate);
                                Layer0Utils.addCommentMetadata((WriteOnlyGraph)graph, (String)("Unlinked a property annotation " + String.valueOf(graph.getRelatedValue2(predicate, L0.HasName, (Binding)Bindings.STRING)) + " " + predicate.toString() + " from " + String.valueOf(graph.getRelatedValue2(subject, L0.HasName, (Binding)Bindings.STRING)) + " " + subject.toString()));
                            } else {
                                graph.deny(subject, ANNO.Annotation_HasEntry, represents);
                                Layer0Utils.addCommentMetadata((WriteOnlyGraph)graph, (String)("Removed an entry annotation " + String.valueOf(graph.getRelatedValue2(subject, L0.HasName, (Binding)Bindings.STRING)) + " " + subject.toString() + " from its container " + String.valueOf(graph.getRelatedValue2(represents, L0.HasName, (Binding)Bindings.STRING))));
                            }
                            if (!graph.hasStatement(represents, L0.PartOf)) {
                                RemoverUtil.remove((WriteGraph)graph, (Resource)represents);
                            }
                        }
                    }
                }
            });
            return true;
        }

        public Object apply(Object p0) {
            ISWTViewNode node = (ISWTViewNode)p0;
            SWTExplorer properties = (SWTExplorer)NodeUtil.browsePossible((INode)node, (String)"./Properties");
            if (properties == null) {
                return null;
            }
            ISelection selection = properties.lastSelection;
            if (selection == null || selection.isEmpty()) {
                this.doRemove((Variable)properties.input);
                return null;
            }
            Set vars = ISelectionUtils.filterSetSelection((Object)selection, Variable.class);
            if (vars.size() != 1) {
                return null;
            }
            Variable selected = (Variable)vars.iterator().next();
            if (!this.doRemove(selected)) {
                this.doRemove((Variable)properties.input);
            }
            return null;
        }
    }

    public static class SaveModifier
    extends FunctionImpl1<Object, Object> {
        private boolean doSave(final Variable variable) {
            if (!AnnotationUtils.isAnnotation(variable)) {
                return false;
            }
            Map<Resource, Pair<String, ImageDescriptor>> map = AnnotationUtils.findLibraries(variable);
            if (map == null) {
                return false;
            }
            AnnotationUtils.queryLibrary(map, selected -> Simantics.getSession().async((WriteInterface)new WriteRequest((Pair)selected){
                private final /* synthetic */ Pair val$selected;
                {
                    this.val$selected = pair;
                }

                public void perform(WriteGraph graph) throws DatabaseException {
                    Resource represents = variable.getPossibleRepresents((ReadGraph)graph);
                    if (represents != null && !((String)this.val$selected.second).isEmpty()) {
                        SaveModifier.saveAnnotation(graph, represents, (Resource)this.val$selected.first, (String)this.val$selected.second);
                    }
                }
            }));
            return true;
        }

        public static Resource saveAnnotation(WriteGraph graph, Resource annotation, Resource library, String name) throws DatabaseException {
            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            if (graph.hasStatement(annotation, L0.PartOf)) {
                graph.deny(annotation, L0.PartOf);
            }
            graph.claim(library, L0.ConsistsOf, L0.PartOf, annotation);
            graph.claimLiteral(annotation, L0.HasName, (Object)name, (Binding)Bindings.STRING);
            return annotation;
        }

        public Object apply(Object p0) {
            ISWTViewNode node = (ISWTViewNode)p0;
            SWTExplorer properties = (SWTExplorer)NodeUtil.browsePossible((INode)node, (String)"./Properties");
            if (properties == null) {
                return null;
            }
            ISelection selection = properties.lastSelection;
            if (selection == null || selection.isEmpty()) {
                this.doSave((Variable)properties.input);
                return null;
            }
            Set vars = ISelectionUtils.filterSetSelection((Object)selection, Variable.class);
            if (vars.size() != 1) {
                return null;
            }
            Variable selected = (Variable)vars.iterator().next();
            if (!this.doSave(selected)) {
                this.doSave((Variable)properties.input);
            }
            return null;
        }
    }

    private static class SetDefaultAnnotationSourceRequest
    extends WriteRequest {
        private Variable context;
        private Object sourceKey;

        public SetDefaultAnnotationSourceRequest(VirtualGraph vg, Variable context, Object sourceKey) {
            super(vg);
            this.context = context;
            this.sourceKey = sourceKey;
        }

        public void perform(WriteGraph graph) throws DatabaseException {
            AnnotationResource ANNO = AnnotationResource.getInstance((ReadGraph)graph);
            Variable selection = ScenegraphLoaderUtils.getVariableSelection((ReadGraph)graph, (Variable)this.context);
            Resource model = Variables.getPossibleIndexRoot((ReadGraph)graph, (Variable)selection);
            List<Tuple3> annos = SCL.availableSourcesImpl((ReadGraph)graph, selection);
            for (Tuple3 anno : annos) {
                if (!anno.get(0).equals(this.sourceKey)) continue;
                graph.claimLiteral(model, ANNO.DefaultAnnotationSource, (Object)((String)anno.get(1)), (Binding)Bindings.STRING);
                break;
            }
        }
    }
}

