/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.participant;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import org.simantics.g2d.canvas.Hints;
import org.simantics.g2d.canvas.impl.AbstractCanvasParticipant;
import org.simantics.g2d.canvas.impl.DependencyReflection;
import org.simantics.g2d.participant.CanvasGrab;
import org.simantics.g2d.participant.MouseUtil;
import org.simantics.g2d.participant.TransformUtil;
import org.simantics.scenegraph.g2d.events.EventHandlerReflection;
import org.simantics.scenegraph.g2d.events.MouseEvent;

public class MultitouchPanZoomRotateInteractor
extends AbstractCanvasParticipant {
    @DependencyReflection.Dependency
    TransformUtil util;
    @DependencyReflection.Dependency
    CanvasGrab grab;
    public static final int BUTTON_ID = 1;

    @EventHandlerReflection.EventHandler(priority=2147481647)
    public boolean handleEvent(MouseEvent.MouseButtonPressedEvent e) {
        if (this.getHint(Hints.KEY_TOOL) != Hints.PANTOOL) {
            return false;
        }
        if (e.mouseId == 0) {
            return false;
        }
        if (e.button != 1) {
            return false;
        }
        this.assertDependencies();
        Point2D controlPos = e.controlPosition;
        Point2D canvasPos = this.util.controlToCanvas(controlPos, null);
        this.grab.grabCanvas(e.mouseId, canvasPos);
        return false;
    }

    @EventHandlerReflection.EventHandler(priority=2147481647)
    public boolean handleEvent(MouseEvent.MouseButtonReleasedEvent e) {
        if (this.getHint(Hints.KEY_TOOL) != Hints.PANTOOL) {
            return false;
        }
        if (e.mouseId == 0) {
            return false;
        }
        if (e.button != 1) {
            return false;
        }
        this.assertDependencies();
        this.grab.grabInfo.remove(e.mouseId);
        return false;
    }

    @EventHandlerReflection.EventHandler(priority=2147481647)
    public boolean handleEvent(MouseEvent.MouseExitEvent e) {
        if (this.getHint(Hints.KEY_TOOL) != Hints.PANTOOL) {
            return false;
        }
        if (e.mouseId == 0) {
            return false;
        }
        this.assertDependencies();
        this.grab.grabInfo.remove(e.mouseId);
        return false;
    }

    @EventHandlerReflection.EventHandler(priority=2147481647)
    public boolean handleEvent(MouseEvent.MouseMovedEvent e) {
        CanvasGrab.PointerInfo[] pi;
        if (e.context instanceof MouseUtil) {
            return false;
        }
        if (this.getHint(Hints.KEY_TOOL) != Hints.PANTOOL) {
            return false;
        }
        this.assertDependencies();
        CanvasGrab.PointerInfo ai = this.grab.grabInfo.get(e.mouseId);
        if (ai == null) {
            return false;
        }
        if (this.grab.grabInfo.size() == 1) {
            CanvasGrab.PointerInfo pi2 = this.grab.grabInfo.values().iterator().next();
            Point2D pt = this.util.controlToCanvas(e.controlPosition, null);
            double a1_x = pi2.anchorPos.getX();
            double a1_y = pi2.anchorPos.getY();
            double b1_x = pt.getX();
            double b1_y = pt.getY();
            AffineTransform gat = this.util.getTransform();
            gat.translate(b1_x - a1_x, b1_y - a1_y);
            this.util.setTransform(gat);
            return true;
        }
        if (this.grab.grabInfo.size() != 2) {
            return false;
        }
        double EPSILON = 3.0;
        CanvasGrab.PointerInfo[] pointerInfoArray = pi = this.grab.grabInfo.values().toArray(new CanvasGrab.PointerInfo[2]);
        int n = pi.length;
        int n2 = 0;
        while (n2 < n) {
            CanvasGrab.PointerInfo p = pointerInfoArray[n2];
            if (p.mouseId == e.mouseId) {
                p.currentPos = this.util.controlToCanvas(e.controlPosition, null);
            }
            ++n2;
        }
        double a1_x = pi[0].anchorPos.getX();
        double a1_y = pi[0].anchorPos.getY();
        double b1_x = pi[0].currentPos.getX();
        double b1_y = pi[0].currentPos.getY();
        double a2_x = pi[1].anchorPos.getX();
        double a2_y = pi[1].anchorPos.getY();
        double b2_x = pi[1].currentPos.getX();
        double b2_y = pi[1].currentPos.getY();
        CanvasGrab.PointerInfo[] pointerInfoArray2 = pi;
        int n3 = pi.length;
        int n4 = 0;
        while (n4 < n3) {
            CanvasGrab.PointerInfo p = pointerInfoArray2[n4];
            if (p.mouseId != e.mouseId) {
                p.currentPos = p.anchorPos;
            }
            ++n4;
        }
        double da_x = a1_x - a2_x;
        double da_y = a1_y - a2_y;
        double da_lensq = da_x * da_x + da_y * da_y;
        if (da_lensq < EPSILON) {
            System.err.println("a1 ja a2 ovat liian l\ufffdhell\ufffd toisiaan");
            return false;
        }
        double db_x = b1_x - b2_x;
        double db_y = b1_y - b2_y;
        double s_x = (db_x * da_x + db_y * da_y) / da_lensq;
        double s_y = (-db_x * da_y + db_y * da_x) / da_lensq;
        double t_x = b1_x - s_x * a1_x + s_y * a1_y;
        double t_y = b1_y - s_x * a1_y - s_y * a1_x;
        double[] mat = new double[]{s_x, s_y, -s_y, s_x, t_x, t_y};
        AffineTransform at = new AffineTransform(mat);
        this.setDirty();
        AffineTransform gat = this.util.getTransform();
        gat.concatenate(at);
        this.util.setTransform(gat);
        return true;
    }
}

