/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.layers;

import java.util.concurrent.CopyOnWriteArrayList;
import org.simantics.g2d.layers.IEditableLayer;

public class SimpleLayer
implements IEditableLayer {
    private CopyOnWriteArrayList<IEditableLayer.ILayerListener> listeners = new CopyOnWriteArrayList();
    private String name;

    public SimpleLayer(String name) {
        if (name == null) {
            throw new IllegalArgumentException("null name");
        }
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("null name");
        }
        String oldName = this.name;
        this.name = name;
        if (!name.equals(oldName)) {
            this.fireLayerChanged(new IEditableLayer.LayerChangeEvent(this, "name", oldName, name));
        }
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SimpleLayer other = (SimpleLayer)obj;
        return this.name.equals(other.name);
    }

    @Override
    public void addLayerListener(IEditableLayer.ILayerListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeLayerListener(IEditableLayer.ILayerListener l) {
        this.listeners.remove(l);
    }

    protected void fireLayerChanged(IEditableLayer.LayerChangeEvent event) {
        for (IEditableLayer.ILayerListener l : this.listeners) {
            l.layerChanged(event);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.name + "]";
    }
}

