/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.element.handler.impl;

import java.util.Collections;
import java.util.Set;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.ElementLayers;
import org.simantics.g2d.layers.ILayer;
import org.simantics.g2d.layers.ILayers;

public class SimpleElementLayers
implements ElementLayers {
    public static final SimpleElementLayers INSTANCE = new SimpleElementLayers();
    private static final long serialVersionUID = 379502115902223354L;

    @Override
    public boolean isVisible(IElement e, ILayers layers) {
        assert (e != null);
        assert (layers != null);
        Set elementLayers = (Set)e.getHint(ElementHints.KEY_VISIBLE_LAYERS);
        if (elementLayers == null) {
            return true;
        }
        return !Collections.disjoint(layers.getVisibleLayers(), elementLayers);
    }

    @Override
    public boolean isVisible(IElement e, ILayer layer) {
        Set elementLayers = (Set)e.getHint(ElementHints.KEY_VISIBLE_LAYERS);
        if (elementLayers == null) {
            return true;
        }
        return elementLayers.contains(layer);
    }

    @Override
    public boolean isFocusable(IElement e, ILayers layers) {
        assert (e != null);
        assert (layers != null);
        Set elementLayers = (Set)e.getHint(ElementHints.KEY_FOCUS_LAYERS);
        if (elementLayers == null) {
            return true;
        }
        return !Collections.disjoint(layers.getVisibleLayers(), elementLayers);
    }

    @Override
    public boolean isFocusable(IElement e, ILayer layer) {
        Set elementLayers = (Set)e.getHint(ElementHints.KEY_FOCUS_LAYERS);
        if (elementLayers == null) {
            return true;
        }
        return elementLayers.contains(layer);
    }
}

