/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.diagram.impl;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.factory.Sets;
import org.simantics.g2d.diagram.DiagramClass;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.diagram.handler.DiagramAdapter;
import org.simantics.g2d.diagram.handler.ElementListener;
import org.simantics.g2d.diagram.handler.LifeCycle;
import org.simantics.g2d.element.IElement;
import org.simantics.utils.datastructures.ListenerList;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.datastructures.hints.IHintListener;
import org.simantics.utils.threads.IThreadWorkQueue;

public class AbstractDiagram
implements IDiagram {
    protected ListenerList<IDiagram.CompositionVetoListener> compositionVetoListeners;
    protected ListenerList<IDiagram.CompositionListener> compositionListeners;
    protected MutableList<IElement> list = Lists.mutable.empty();
    protected MutableSet<IElement> elements = Sets.mutable.empty();
    protected volatile ImmutableList<IElement> snapshot = null;
    private DiagramClass clazz;
    protected IHintContext hintCtx;

    public AbstractDiagram(DiagramClass clazz, IHintContext hintCtx) {
        if (clazz == null) {
            throw new NullPointerException("null clazz");
        }
        this.clazz = clazz;
        this.hintCtx = hintCtx;
    }

    @Override
    public void destroy() {
        List<IElement> ss = this.getElements();
        this.dispose();
        for (IElement e : ss) {
            e.destroy();
        }
        for (LifeCycle lc : this.clazz.getItemsByClass(LifeCycle.class)) {
            lc.onDiagramDestroyed(this);
        }
    }

    @Override
    public void dispose() {
        List<IElement> ss = this.getElements();
        for (IElement e : ss) {
            for (org.simantics.g2d.element.handler.LifeCycle lc : e.getElementClass().getItemsByClass(org.simantics.g2d.element.handler.LifeCycle.class)) {
                lc.onElementDeactivated(this, e);
            }
        }
        this.fireDeactivated();
        for (IElement e : ss) {
            e.addedToDiagram(null);
            e.dispose();
        }
        this.list.clear();
        this.snapshot = null;
        this.hintCtx.clearWithoutNotification();
    }

    @Override
    public DiagramClass getDiagramClass() {
        return this.clazz;
    }

    @Override
    public synchronized void addCompositionListener(IDiagram.CompositionListener listener) {
        if (this.compositionListeners == null) {
            this.compositionListeners = new ListenerList(IDiagram.CompositionListener.class);
        }
        this.compositionListeners.add((Object)listener);
    }

    @Override
    public synchronized void removeCompositionListener(IDiagram.CompositionListener listener) {
        if (this.compositionListeners == null) {
            return;
        }
        this.compositionListeners.remove((Object)listener);
        if (this.compositionListeners.isEmpty()) {
            this.compositionListeners = null;
        }
    }

    @Override
    public synchronized void addCompositionVetoListener(IDiagram.CompositionVetoListener listener) {
        if (this.compositionVetoListeners == null) {
            this.compositionVetoListeners = new ListenerList(IDiagram.CompositionVetoListener.class);
        }
        this.compositionVetoListeners.add((Object)listener);
    }

    @Override
    public synchronized void removeCompositionVetoListener(IDiagram.CompositionVetoListener listener) {
        if (this.compositionVetoListeners == null) {
            return;
        }
        this.compositionVetoListeners.remove((Object)listener);
        if (this.compositionVetoListeners.isEmpty()) {
            this.compositionVetoListeners = null;
        }
    }

    @Override
    public synchronized void addElement(IElement e) {
        assert (this.clazz != null);
        if (!this.fireBeforeElementAdded(e)) {
            System.out.println("Element addition VETOED for " + String.valueOf(e));
            return;
        }
        this.snapshot = null;
        this.list.add((Object)e);
        this.elements.add((Object)e);
        e.addedToDiagram(this);
        for (org.simantics.g2d.element.handler.LifeCycle lc : e.getElementClass().getItemsByClass(org.simantics.g2d.element.handler.LifeCycle.class)) {
            lc.onElementActivated(this, e);
        }
        for (ElementListener el : this.clazz.getItemsByClass(ElementListener.class)) {
            el.onElementAdded(this, e);
        }
        this.fireElementAdded(e);
    }

    protected void assertHasElement(IElement e) {
        assert (this.elements.contains((Object)e));
    }

    @Override
    public boolean containsElement(IElement element) {
        return this.elements.contains((Object)element);
    }

    @Override
    public synchronized void removeElement(IElement e) {
        if (!this.fireBeforeElementRemoved(e)) {
            System.out.println("Element removal VETOED for " + String.valueOf(e));
            return;
        }
        boolean removed = this.elements.remove((Object)e);
        assert (removed);
        this.list.remove((Object)e);
        this.snapshot = null;
        e.addedToDiagram(null);
        for (ElementListener el : this.clazz.getItemsByClass(ElementListener.class)) {
            el.onElementRemoved(this, e);
        }
        for (org.simantics.g2d.element.handler.LifeCycle lc : e.getElementClass().getItemsByClass(org.simantics.g2d.element.handler.LifeCycle.class)) {
            lc.onElementDeactivated(this, e);
        }
        this.fireElementRemoved(e);
    }

    protected boolean fireBeforeElementAdded(IElement e) {
        if (this.compositionVetoListeners == null) {
            return true;
        }
        IDiagram.CompositionVetoListener[] compositionVetoListenerArray = (IDiagram.CompositionVetoListener[])this.compositionVetoListeners.getListeners();
        int n = compositionVetoListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDiagram.CompositionVetoListener l = compositionVetoListenerArray[n2];
            if (!l.beforeElementAdded(this, e)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    protected boolean fireBeforeElementRemoved(IElement e) {
        if (this.compositionVetoListeners == null) {
            return true;
        }
        IDiagram.CompositionVetoListener[] compositionVetoListenerArray = (IDiagram.CompositionVetoListener[])this.compositionVetoListeners.getListeners();
        int n = compositionVetoListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDiagram.CompositionVetoListener l = compositionVetoListenerArray[n2];
            if (!l.beforeElementRemoved(this, e)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    protected void fireElementAdded(IElement e) {
        if (this.compositionListeners == null) {
            return;
        }
        IDiagram.CompositionListener[] compositionListenerArray = (IDiagram.CompositionListener[])this.compositionListeners.getListeners();
        int n = compositionListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDiagram.CompositionListener l = compositionListenerArray[n2];
            l.onElementAdded(this, e);
            ++n2;
        }
    }

    protected void fireElementRemoved(IElement e) {
        if (this.compositionListeners == null) {
            return;
        }
        IDiagram.CompositionListener[] compositionListenerArray = (IDiagram.CompositionListener[])this.compositionListeners.getListeners();
        int n = compositionListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDiagram.CompositionListener l = compositionListenerArray[n2];
            l.onElementRemoved(this, e);
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IElement> getSnapshot() {
        ImmutableList snap = this.snapshot;
        if (snap != null) {
            return snap.castToList();
        }
        AbstractDiagram abstractDiagram = this;
        synchronized (abstractDiagram) {
            snap = this.snapshot;
            if (snap == null) {
                this.snapshot = snap = this.list.toImmutable();
            }
        }
        return snap.castToList();
    }

    protected static void fireDestroyed(IDiagram e) {
        for (LifeCycle lc : e.getDiagramClass().getItemsByClass(LifeCycle.class)) {
            lc.onDiagramDestroyed(e);
        }
    }

    protected static void fireDeactivated(IDiagram e) {
        for (LifeCycle lc : e.getDiagramClass().getItemsByClass(LifeCycle.class)) {
            lc.onDiagramDisposed(e);
        }
    }

    protected static void fireCreated(IDiagram e) {
        for (LifeCycle lc : e.getDiagramClass().getItemsByClass(LifeCycle.class)) {
            lc.onDiagramCreated(e);
        }
    }

    protected static void fireLoaded(IDiagram e) {
        for (LifeCycle lc : e.getDiagramClass().getItemsByClass(LifeCycle.class)) {
            lc.onDiagramLoaded(e, e.getElements());
        }
    }

    protected void fireCreated() {
        AbstractDiagram.fireCreated(this);
    }

    protected void fireLoaded() {
        AbstractDiagram.fireLoaded(this);
    }

    protected void fireDestroyed() {
        AbstractDiagram.fireDestroyed(this);
    }

    protected void fireDeactivated() {
        AbstractDiagram.fireDeactivated(this);
    }

    public void clearWithoutNotification() {
        this.hintCtx.clearWithoutNotification();
    }

    public <E> E removeHint(IHintContext.Key key) {
        return (E)this.hintCtx.removeHint(key);
    }

    public void setHint(IHintContext.Key key, Object value) {
        this.hintCtx.setHint(key, value);
    }

    public void setHints(Map<IHintContext.Key, Object> hints) {
        this.hintCtx.setHints(hints);
    }

    public void addHintListener(IHintListener listener) {
        this.hintCtx.addHintListener(listener);
    }

    public void addHintListener(IThreadWorkQueue threadAccess, IHintListener listener) {
        this.hintCtx.addHintListener(threadAccess, listener);
    }

    public void addKeyHintListener(IHintContext.Key key, IHintListener listener) {
        this.hintCtx.addKeyHintListener(key, listener);
    }

    public void addKeyHintListener(IThreadWorkQueue threadAccess, IHintContext.Key key, IHintListener listener) {
        this.hintCtx.addKeyHintListener(threadAccess, key, listener);
    }

    public boolean containsHint(IHintContext.Key key) {
        return this.hintCtx.containsHint(key);
    }

    public <E> E getHint(IHintContext.Key key) {
        return (E)this.hintCtx.getHint(key);
    }

    public Map<IHintContext.Key, Object> getHints() {
        return this.hintCtx.getHints();
    }

    public Map<IHintContext.Key, Object> getHintsUnsafe() {
        return this.hintCtx.getHintsUnsafe();
    }

    public <E extends IHintContext.Key> Map<E, Object> getHintsOfClass(Class<E> clazz) {
        return this.hintCtx.getHintsOfClass(clazz);
    }

    public void removeHintListener(IHintListener listener) {
        this.hintCtx.removeHintListener(listener);
    }

    public void removeHintListener(IThreadWorkQueue threadAccess, IHintListener listener) {
        this.hintCtx.removeHintListener(threadAccess, listener);
    }

    public void removeKeyHintListener(IHintContext.Key key, IHintListener listener) {
        this.hintCtx.removeKeyHintListener(key, listener);
    }

    public void removeKeyHintListener(IThreadWorkQueue threadAccess, IHintContext.Key key, IHintListener listener) {
        this.hintCtx.removeKeyHintListener(threadAccess, key, listener);
    }

    @Override
    public boolean bringToTop(IElement e) {
        this.assertHasElement(e);
        if (this.list.get(this.list.size() - 1) == e) {
            return false;
        }
        this.list.add((Object)e);
        this.list.remove((Object)e);
        this.snapshot = null;
        return true;
    }

    @Override
    public boolean bringUp(IElement e) {
        this.assertHasElement(e);
        int i = this.list.indexOf((Object)e);
        if (i == this.list.size() - 1) {
            return false;
        }
        int j = i + 1;
        IElement upper = (IElement)this.list.get(j);
        this.list.set(j, (Object)e);
        this.list.set(i, (Object)upper);
        this.snapshot = null;
        return true;
    }

    @Override
    public boolean sendDown(IElement e) {
        this.assertHasElement(e);
        int i = this.list.indexOf((Object)e);
        if (i == 0) {
            return false;
        }
        int j = i - 1;
        IElement lower = (IElement)this.list.get(j);
        this.list.set(j, (Object)e);
        this.list.set(i, (Object)lower);
        this.snapshot = null;
        return true;
    }

    @Override
    public boolean sendToBottom(IElement e) {
        this.assertHasElement(e);
        if (this.list.get(0) == e) {
            return false;
        }
        this.list.remove((Object)e);
        this.list.add(0, (Object)e);
        this.snapshot = null;
        return true;
    }

    @Override
    public boolean moveTo(IElement e, int position) {
        this.assertHasElement(e);
        int indexOf = this.list.indexOf((Object)e);
        if (indexOf == position) {
            return false;
        }
        this.list.remove(indexOf);
        this.list.add(position, (Object)e);
        this.snapshot = null;
        return true;
    }

    @Override
    public List<IElement> getElements() {
        return this.getSnapshot();
    }

    @Override
    public void sort(Comparator<IElement> comparator) {
        Collections.sort(this.list, comparator);
    }

    public Object getAdapter(Class adapter) {
        for (DiagramAdapter ea : this.clazz.getItemsByClass(DiagramAdapter.class)) {
            Object result = ea.getAdapter(this, adapter);
            if (result == null) continue;
            return result;
        }
        return null;
    }
}

