/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.canvas.impl;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.simantics.g2d.canvas.SGDesignation;
import org.simantics.scenegraph.g2d.G2DParentNode;

public class SGNodeReflection {
    public static CanvasSGNodeDefinition[] getSGHandlers(Object obj) {
        Method m;
        ArrayList<CanvasSGNodeDefinition> result = new ArrayList<CanvasSGNodeDefinition>();
        Class<?> clazz = obj.getClass();
        Method[] methodArray = clazz.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            m = methodArray[n2];
            SGInit initAnno = m.getAnnotation(SGInit.class);
            if (initAnno != null) {
                SGDesignation initDesignation = initAnno.designation();
                Class<?> returnType = m.getReturnType();
                if (!returnType.equals(Void.TYPE)) {
                    throw new RuntimeException(clazz.getName() + "." + m.getName() + " return type is invalid");
                }
                Class<?>[] argTypes = m.getParameterTypes();
                if (argTypes.length != 1 || !argTypes[0].equals(G2DParentNode.class)) {
                    throw new RuntimeException(clazz.getName() + "." + m.getName() + " invalid arguments");
                }
                Class<?>[] exceptionTypes = m.getExceptionTypes();
                if (exceptionTypes.length != 0) {
                    throw new RuntimeException(clazz.getName() + "." + m.getName() + " invalid exceptions");
                }
                try {
                    m.setAccessible(true);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    throw new Error(t);
                }
                CanvasSGNodeDefinition def = new CanvasSGNodeDefinition(m, initDesignation, null, obj);
                result.add(def);
            }
            ++n2;
        }
        methodArray = clazz.getMethods();
        n = methodArray.length;
        n2 = 0;
        while (n2 < n) {
            m = methodArray[n2];
            SGCleanup cleanupAnno = m.getAnnotation(SGCleanup.class);
            if (cleanupAnno != null) {
                Class<?> returnType = m.getReturnType();
                if (!returnType.equals(Void.TYPE)) {
                    throw new RuntimeException(clazz.getName() + "." + m.getName() + " return type is invalid");
                }
                Class<?>[] argTypes = m.getParameterTypes();
                if (argTypes.length != 0) {
                    throw new RuntimeException(clazz.getName() + "." + m.getName() + " invalid arguments");
                }
                Class<?>[] exceptionTypes = m.getExceptionTypes();
                if (exceptionTypes.length != 0) {
                    throw new RuntimeException(clazz.getName() + "." + m.getName() + " invalid exceptions");
                }
                try {
                    m.setAccessible(true);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    throw new Error(t);
                }
                CanvasSGNodeDefinition def = new CanvasSGNodeDefinition(null, null, m, obj);
                result.add(def);
            }
            ++n2;
        }
        return result.toArray(new CanvasSGNodeDefinition[0]);
    }

    public static class CanvasSGNodeDefinition {
        public final Method initMethod;
        public final SGDesignation initDesignation;
        public final Method cleanupMethod;
        public final Object obj;

        public void init(G2DParentNode parent) {
            if (this.initMethod == null) {
                return;
            }
            try {
                this.initMethod.invoke(this.obj, parent);
            }
            catch (IllegalArgumentException e) {
                throw new Error(e);
            }
            catch (IllegalAccessException e) {
                throw new Error(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e.getCause());
            }
        }

        public void cleanup() {
            if (this.cleanupMethod == null) {
                return;
            }
            try {
                this.cleanupMethod.invoke(this.obj, new Object[0]);
            }
            catch (IllegalArgumentException e) {
                throw new Error(e);
            }
            catch (IllegalAccessException e) {
                throw new Error(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e.getCause());
            }
        }

        public CanvasSGNodeDefinition(Method initMethod, SGDesignation initDesignation, Method cleanupMethod, Object obj) {
            this.initMethod = initMethod;
            this.initDesignation = initDesignation;
            this.cleanupMethod = cleanupMethod;
            this.obj = obj;
        }

        public String toString() {
            return String.format("%s %s %s %s", this.obj.getClass().getSimpleName(), this.initMethod != null ? this.initMethod.getName() : "no init method", this.initDesignation != null ? this.initDesignation.toString() : "no init designation", this.cleanupMethod != null ? this.cleanupMethod.getName() : "no cleanup method");
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface SGCleanup {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface SGInit {
        public SGDesignation designation() default SGDesignation.CANVAS;
    }
}

