/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.logging;

import java.util.Objects;
import org.slf4j.Logger;

public class LoggerLevel
implements Comparable<LoggerLevel> {
    private final Logger logger;
    private final String originalLevel;
    private String loggerName;
    private String level;

    public LoggerLevel(Logger logger, String level) {
        Objects.requireNonNull(logger, "logger");
        Objects.requireNonNull(level, "level");
        this.logger = logger;
        this.originalLevel = level;
        this.loggerName = logger.getName();
        this.level = level;
    }

    public LoggerLevel(String loggerName, String level) {
        Objects.requireNonNull(loggerName, "loggerName");
        Objects.requireNonNull(level, "level");
        this.logger = null;
        this.originalLevel = null;
        this.loggerName = loggerName;
        this.level = level;
    }

    Logger getLogger() {
        return this.logger;
    }

    public String getName() {
        return this.loggerName;
    }

    public LoggerLevel setName(String name) {
        if (this.logger != null) {
            throw new UnsupportedOperationException("Cannot rename already created logger " + this.loggerName + " to " + name);
        }
        Objects.requireNonNull(name, "name");
        this.loggerName = name;
        return this;
    }

    public String getLevel() {
        return this.level;
    }

    public LoggerLevel setLevel(String level) {
        Objects.requireNonNull(level, "level");
        this.level = level;
        return this;
    }

    public boolean levelChanged() {
        return !Objects.equals(this.originalLevel, this.level);
    }

    public boolean isLoggerDefined() {
        return this.logger != null;
    }

    public int hashCode() {
        return Objects.hash(this.level, this.logger, this.loggerName);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LoggerLevel other = (LoggerLevel)obj;
        return Objects.equals(this.level, other.level) && Objects.equals(this.logger, other.logger) && Objects.equals(this.loggerName, other.loggerName);
    }

    @Override
    public int compareTo(LoggerLevel o) {
        return this.loggerName.compareToIgnoreCase(o.loggerName);
    }
}

