/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.issues.ui.property;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchSite;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.procedure.adapter.TransientCacheListener;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.issues.Severity;
import org.simantics.issues.common.IssueResourceContexts;
import org.simantics.issues.common.ListModelIssuesBySeverity;
import org.simantics.issues.common.SimpleIssue;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.selectionview.PropertyTabContributorImpl;

public class IssuesTab
extends PropertyTabContributorImpl {
    private TableViewer viewer;
    private Resource model;
    private Resource element;
    private List<SimpleIssue> result;

    public IssuesTab(ReadGraph graph, Resource model, Resource element) throws DatabaseException {
        this.model = model;
        this.element = element;
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        List<Resource> contexts = this.getContexts(graph, element);
        Map issuesBySeverity = (Map)graph.syncRequest((Read)new ListModelIssuesBySeverity(model, true, true, Severity.NOTE), (Listener)TransientCacheListener.instance());
        this.result = new ArrayList<SimpleIssue>();
        Severity[] severityArray = Severity.values();
        int n = severityArray.length;
        int n2 = 0;
        while (n2 < n) {
            Severity severity = severityArray[n2];
            List issues = (List)issuesBySeverity.get(severity);
            if (issues != null) {
                for (Resource issue : issues) {
                    Set issueContexts = (Set)graph.syncRequest((Read)new IssueResourceContexts(issue));
                    if (Collections.disjoint(issueContexts, contexts)) continue;
                    SimpleIssue si = new SimpleIssue((String)graph.getRelatedValue(issue, L0.HasLabel, (Binding)Bindings.STRING), severity, issue);
                    this.result.add(si);
                    System.out.println(si.label + " " + String.valueOf(si.severity));
                }
            }
            ++n2;
        }
    }

    protected List<Resource> getContexts(ReadGraph graph, Resource element) throws DatabaseException {
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        ArrayList<Resource> result = new ArrayList<Resource>(3);
        result.add(element);
        Resource config = graph.getPossibleObject(element, MOD.ElementToComponent);
        if (config != null && result.indexOf(config) == -1) {
            result.add(config);
        }
        if ((config = graph.getPossibleObject(element, MOD.DiagramConnectionToConnection)) != null && result.indexOf(config) == -1) {
            result.add(config);
        }
        if ((config = graph.getPossibleObject(element, MOD.HasParentComponent)) != null && result.indexOf(config) == -1) {
            result.add(config);
        }
        return result;
    }

    public void createControls(Composite body, IWorkbenchSite site, ISessionContext context, WidgetSupport support) {
        GridLayoutFactory.fillDefaults().numColumns(2).spacing(0, 0).applyTo(body);
        this.viewer = new TableViewer(body);
        TableViewerColumn issueColumn = new TableViewerColumn(this.viewer, 16384);
        TableViewerColumn severityColumn = new TableViewerColumn(this.viewer, 16384);
        issueColumn.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                SimpleIssue issue = (SimpleIssue)cell.getElement();
                cell.setText(issue.label);
            }
        });
        severityColumn.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                SimpleIssue issue = (SimpleIssue)cell.getElement();
                cell.setText(issue.severity.name());
            }
        });
        issueColumn.getColumn().setWidth(300);
        issueColumn.getColumn().setText("Issue");
        severityColumn.getColumn().setWidth(100);
        severityColumn.getColumn().setText("Severity");
        this.viewer.getTable().setHeaderVisible(true);
        this.viewer.getTable().setLinesVisible(true);
        this.viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                List list = (List)inputElement;
                return list.toArray();
            }
        });
        this.viewer.setInput(this.result);
        GridDataFactory.fillDefaults().grab(true, true).applyTo(this.viewer.getControl());
    }

    public Read<String> getPartNameReadRequest(ISelection forSelection) {
        return new ObjectTitleRead(this.element);
    }

    public static class ObjectTitleRead
    extends ResourceRead<String> {
        public ObjectTitleRead(Resource resource) {
            super(resource);
        }

        public String perform(ReadGraph graph) throws DatabaseException {
            return NameUtils.getSafeName((ReadGraph)graph, (Resource)this.resource);
        }
    }
}

