/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.ui.workbench.ui;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IMemento;

public class TableColumnSorter {
    protected final TableViewer viewer;
    protected final ColumnSorter sorter;
    protected Map<Integer, Comparator<?>> columnComparators = new HashMap();
    private static final String PRI_ASC = "PriAsc";
    private static final String SEC_ASC = "SecAsc";
    private static final String PRI_IND = "PriInd";
    private static final String SEC_IND = "SecInd";

    public static TableColumnSorter attachTableColumnSorter(TableViewer viewer) {
        return new TableColumnSorter(viewer);
    }

    public static void unattachTableColumnSorter(TableViewer viewer) {
        viewer.setSorter(null);
    }

    public void setColumnComparator(int index, Comparator<?> comparator) {
        this.columnComparators.put(index, comparator);
        this.viewer.refresh();
    }

    public void saveState(String id, IMemento memento) {
        memento.putInteger(id + PRI_ASC, this.sorter.isAscending() ? 1 : 0);
        memento.putInteger(id + SEC_ASC, this.sorter.isSecondaryAscending() ? 1 : 0);
        memento.putInteger(id + PRI_IND, this.sorter.getIndex());
        memento.putInteger(id + SEC_IND, this.sorter.getSecondaryIndex());
    }

    public void restoreState(String id, IMemento memento) {
        if (!this.hasState(id, memento)) {
            return;
        }
        this.sorter.setAscending(memento.getInteger(id + PRI_ASC) == 1);
        this.sorter.setSecondaryAscending(memento.getInteger(id + SEC_ASC) == 1);
        this.sorter.setIndex(memento.getInteger(id + PRI_IND));
        this.sorter.setSecondaryIndex(memento.getInteger(id + SEC_IND));
        this.viewer.refresh();
    }

    public boolean hasState(String id, IMemento memento) {
        return memento.getInteger(id + PRI_ASC) != null && memento.getInteger(id + SEC_ASC) != null && memento.getInteger(id + PRI_IND) != null && memento.getInteger(id + SEC_IND) != null;
    }

    public void setColumnAscending(int index) {
        this.sorter.setIndex(index);
        this.sorter.setAscending(true);
        this.viewer.refresh();
    }

    private TableColumnSorter(TableViewer viewer) {
        this.viewer = viewer;
        this.sorter = new ColumnSorter();
        TableColumn[] columns = viewer.getTable().getColumns();
        int i = 0;
        while (i < columns.length) {
            TableColumn column = columns[i];
            column.setData("index", (Object)new Integer(i));
            column.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    int index = (Integer)e.widget.getData("index");
                    if (index == TableColumnSorter.this.sorter.getIndex()) {
                        TableColumnSorter.this.sorter.setAscending(!TableColumnSorter.this.sorter.isAscending());
                    } else {
                        TableColumnSorter.this.sorter.setSecondaryIndex(TableColumnSorter.this.sorter.getIndex());
                        TableColumnSorter.this.sorter.setSecondaryAscending(TableColumnSorter.this.sorter.isAscending());
                        TableColumnSorter.this.sorter.setIndex(index);
                        TableColumnSorter.this.sorter.setAscending(true);
                    }
                    TableColumnSorter.this.viewer.refresh();
                }
            });
            ++i;
        }
        viewer.setSorter((ViewerSorter)this.sorter);
    }

    public ColumnSorter getSorter() {
        return this.sorter;
    }

    class ColumnSorter
    extends ViewerSorter {
        private boolean ascending = true;
        private boolean secondaryAscending = true;
        private int columnIndex = 0;
        private int secondaryColumnIndex = -1;
        private boolean caseSensitive = false;

        ColumnSorter() {
        }

        public void setAscending(boolean ascending) {
            this.ascending = ascending;
        }

        public boolean isAscending() {
            return this.ascending;
        }

        public void setSecondaryAscending(boolean ascending) {
            this.secondaryAscending = ascending;
        }

        public boolean isSecondaryAscending() {
            return this.secondaryAscending;
        }

        public void setIndex(int index) {
            this.columnIndex = index;
        }

        public int getIndex() {
            return this.columnIndex;
        }

        public void setSecondaryIndex(int index) {
            this.secondaryColumnIndex = index;
        }

        public int getSecondaryIndex() {
            return this.secondaryColumnIndex;
        }

        private int compare(int columnIndex, String text1, String text2, Object o1, Object o2) {
            Comparator<?> c = TableColumnSorter.this.columnComparators.get(columnIndex);
            if (c == null || o1 == null || o2 == null) {
                return text1.compareTo(text2);
            }
            return c.compare(o1, o2);
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            int result = 0;
            TableViewer v = (TableViewer)viewer;
            IBaseLabelProvider blp = v.getLabelProvider();
            if (!(blp instanceof ITableLabelProvider)) {
                return super.compare(viewer, e1, e2);
            }
            ITableLabelProvider tlp = (ITableLabelProvider)blp;
            String text1 = tlp.getColumnText(e1, this.columnIndex);
            String text2 = tlp.getColumnText(e2, this.columnIndex);
            if (text1 == null) {
                text1 = "";
            }
            if (text2 == null) {
                text2 = "";
            }
            if (!this.caseSensitive) {
                text1 = text1.toLowerCase();
                text2 = text2.toLowerCase();
            }
            result = this.compare(this.columnIndex, text1, text2, e1, e2);
            if (!this.ascending) {
                return -result;
            }
            if (result == 0 && this.secondaryColumnIndex >= 0) {
                text1 = tlp.getColumnText(e1, this.secondaryColumnIndex);
                text2 = tlp.getColumnText(e2, this.secondaryColumnIndex);
                if (text1 == null) {
                    text1 = "";
                }
                if (text2 == null) {
                    text2 = "";
                }
                if (!this.caseSensitive) {
                    text1 = text1.toLowerCase();
                    text2 = text2.toLowerCase();
                }
                result = this.compare(this.secondaryColumnIndex, text1, text2, e1, e2);
                if (!this.secondaryAscending) {
                    return -result;
                }
            }
            return result;
        }

        public boolean isCaseSensitive() {
            return this.caseSensitive;
        }

        public void setCaseSensitive(boolean caseSensitive) {
            this.caseSensitive = caseSensitive;
        }
    }
}

