/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.spreadsheet.solver.formula;

import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.spreadsheet.SpreadsheetMatrix;
import org.simantics.spreadsheet.Spreadsheets;
import org.simantics.spreadsheet.solver.formula.CellFormulaFunction;
import org.simantics.spreadsheet.solver.formula.CellValueVisitor;
import org.simantics.spreadsheet.solver.formula.FormulaError2;
import org.simantics.spreadsheet.solver.formula.parser.ast.AstArgList;

public class MatchFormulaFunction
implements CellFormulaFunction<Object> {
    @Override
    public Object evaluate(CellValueVisitor visitor, AstArgList args) {
        if (args.values.size() < 2 || args.values.size() > 3) {
            throw new IllegalStateException();
        }
        SpreadsheetMatrix lookup_array = (SpreadsheetMatrix)args.values.get(1).accept(visitor);
        if (lookup_array.getWidth() != 1 && lookup_array.getHeight() != 1) {
            return FormulaError2.NA.getString();
        }
        Object lookup_value = args.values.get(0).accept(visitor);
        int match_type = 1;
        try {
            if (args.values.size() == 3) {
                int matchArg = ((Number)args.values.get(2).accept(visitor)).intValue();
                match_type = matchArg < 0 ? -1 : (matchArg > 0 ? 1 : 0);
            }
        }
        catch (Exception exception) {
            return FormulaError2.NA.getString();
        }
        boolean useHeight = false;
        if (lookup_array.getWidth() == 1) {
            useHeight = true;
        }
        int max = 0;
        max = useHeight ? lookup_array.getHeight() : lookup_array.getWidth();
        Integer pos = null;
        if (lookup_value instanceof Variant) {
            Object obj = ((Variant)lookup_value).getValue();
            Number nVal = Spreadsheets.asValidNumber(obj);
            obj = nVal != null ? nVal : obj.toString();
        }
        if (lookup_value instanceof Number) {
            int begin;
            previousValue = null;
            closestMatch = null;
            Double lookup = ((Number)lookup_value).doubleValue();
            int indexWhereCorrectOrderStartsAt = 0;
            if (match_type != 0) {
                int i = 0;
                while (i < max) {
                    Double currValue = null;
                    Number currNum = useHeight ? (Number)Spreadsheets.asValidNumber(lookup_array.get(i, 0)) : (Number)Spreadsheets.asValidNumber(lookup_array.get(0, i));
                    if (currNum != null && (currValue = Double.valueOf(currNum.doubleValue())) != null) {
                        if (previousValue != null) {
                            if (!(match_type == -1 && currValue > (Double)previousValue) && (match_type != 1 || !(currValue < (Double)previousValue))) break;
                            indexWhereCorrectOrderStartsAt = i;
                        }
                        previousValue = currValue;
                    }
                    ++i;
                }
            }
            int i = begin = indexWhereCorrectOrderStartsAt;
            while (i < max) {
                Double currValue = null;
                Number currNum = useHeight ? (Number)Spreadsheets.asValidNumber(lookup_array.get(i, 0)) : (Number)Spreadsheets.asValidNumber(lookup_array.get(0, i));
                if (currNum != null && (currValue = Double.valueOf(currNum.doubleValue())) != null) {
                    int comp;
                    if (previousValue == null) {
                        previousValue = currValue;
                    }
                    if (match_type == -1 && currValue > (Double)previousValue || match_type == 1 && currValue < (Double)previousValue) {
                        if (pos != null) {
                            return pos + 1;
                        }
                        previousValue = currValue;
                    }
                    if ((comp = lookup.compareTo(currValue)) == 0) {
                        closestMatch = currValue;
                        pos = i;
                    } else if (comp > 0 && match_type == 1 || comp < 0 && match_type == -1) {
                        if (closestMatch == null && pos == null) {
                            closestMatch = currValue;
                            pos = i;
                        } else if (currValue.compareTo((Double)closestMatch) >= 0 && match_type == 1 || currValue.compareTo((Double)closestMatch) <= 0 && match_type == -1) {
                            closestMatch = currValue;
                            pos = i;
                        }
                    }
                    previousValue = currValue;
                }
                ++i;
            }
        } else if (lookup_value instanceof String) {
            int begin;
            previousValue = null;
            closestMatch = null;
            String lookup = (String)lookup_value;
            int indexWhereCorrectOrderStartsAt = 0;
            if (match_type != 0) {
                int i = 0;
                while (i < max) {
                    String currValue = null;
                    Object obj = useHeight ? lookup_array.get(i, 0) : lookup_array.get(0, i);
                    if (obj instanceof Variant) {
                        obj = ((Variant)obj).getValue();
                    }
                    if (obj != null && !(obj instanceof Number)) {
                        currValue = obj.toString();
                        currValue = currValue.toLowerCase();
                    }
                    if (currValue != null && !currValue.equals("")) {
                        if (previousValue != null) {
                            if ((match_type != -1 || currValue.compareTo((String)previousValue) <= 0) && (match_type != 1 || currValue.compareTo((String)previousValue) >= 0)) break;
                            indexWhereCorrectOrderStartsAt = i;
                        }
                        previousValue = currValue;
                    }
                    ++i;
                }
            }
            int i = begin = indexWhereCorrectOrderStartsAt;
            while (i < max) {
                String currValue = null;
                Object obj = useHeight ? lookup_array.get(i, 0) : lookup_array.get(0, i);
                if (obj instanceof Variant) {
                    obj = ((Variant)obj).getValue();
                }
                if (obj != null && !(obj instanceof Number)) {
                    currValue = obj.toString();
                    currValue = currValue.toLowerCase();
                }
                if (currValue != null && !currValue.equals("")) {
                    int comp;
                    if (previousValue == null) {
                        previousValue = currValue;
                    }
                    if (match_type == -1 && currValue.compareTo((String)previousValue) > 0 || match_type == 1 && currValue.compareTo((String)previousValue) < 0) {
                        if (pos != null) {
                            return pos + 1;
                        }
                        previousValue = currValue;
                    }
                    if ((comp = lookup.compareTo(currValue)) == 0) {
                        closestMatch = currValue;
                        pos = i;
                    } else if (comp > 0 && match_type == 1 || comp < 0 && match_type == -1) {
                        if (closestMatch == null && pos == null) {
                            closestMatch = currValue;
                            pos = i;
                        } else if (currValue.compareTo((String)closestMatch) >= 0 && match_type == 1 || currValue.compareTo((String)closestMatch) <= 0 && match_type == -1) {
                            closestMatch = currValue;
                            pos = i;
                        }
                    }
                    previousValue = currValue;
                }
                ++i;
            }
        }
        if (pos == null) {
            return FormulaError2.NA.getString();
        }
        return pos + 1;
    }
}

