/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.spreadsheet.solver;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.spreadsheet.ExternalRef;
import org.simantics.spreadsheet.SpreadsheetCellStyle;
import org.simantics.spreadsheet.SpreadsheetVisitor;
import org.simantics.spreadsheet.Spreadsheets;
import org.simantics.spreadsheet.solver.BinarySearch;
import org.simantics.spreadsheet.solver.ExternalRefData;
import org.simantics.spreadsheet.solver.SheetNode;
import org.simantics.spreadsheet.solver.SpreadsheetBook;
import org.simantics.spreadsheet.solver.SpreadsheetCellContent;
import org.simantics.spreadsheet.solver.SpreadsheetCellEditable;
import org.simantics.spreadsheet.solver.SpreadsheetElement;
import org.simantics.spreadsheet.solver.SpreadsheetEngine;
import org.simantics.spreadsheet.solver.SpreadsheetFormula;
import org.simantics.spreadsheet.solver.SpreadsheetLine;
import org.simantics.spreadsheet.solver.SpreadsheetSCLConstant;
import org.simantics.spreadsheet.solver.SpreadsheetStyle;
import org.simantics.spreadsheet.solver.SpreadsheetTypeNode;
import org.simantics.spreadsheet.solver.formula.CellValueVisitor;
import org.simantics.spreadsheet.solver.formula.FormulaError2;
import org.simantics.spreadsheet.solver.formula.SpreadsheetEvaluationEnvironment;
import org.simantics.spreadsheet.solver.formula.parser.ast.AstValue;

public class SpreadsheetCell
extends BinarySearch
implements SpreadsheetElement,
SheetNode {
    private static final long serialVersionUID = 6616793596542239339L;
    public static SpreadsheetCell EMPTY = new SpreadsheetCell(null, -1);
    private boolean inProgress = false;
    private int iterations = 0;
    private final SpreadsheetLine line;
    int style;
    Object content;
    private final Map<String, SheetNode> properties = this.createProperties();

    static {
        EMPTY.setContent("");
        EMPTY.setStyle(SpreadsheetStyle.empty().getStyleId());
    }

    public SpreadsheetCell(SpreadsheetLine line, int column) {
        super(column);
        this.line = line;
    }

    private Map<String, SheetNode> createProperties() {
        HashMap<String, SheetNode> p = new HashMap<String, SheetNode>();
        p.put("typeURI", new SpreadsheetTypeNode("http://www.simantics.org/Spreadsheet-1.2/Cell"));
        p.put("content", new SpreadsheetCellContent(this));
        p.put("style", new SpreadsheetCellStyle(this));
        p.put("editable", new SpreadsheetCellEditable(this));
        return p;
    }

    public boolean hasExpression() {
        return this.content instanceof SpreadsheetFormula || this.content instanceof SpreadsheetSCLConstant;
    }

    public void setContent(Object newContent) {
        this.content = newContent;
    }

    public int getColumn() {
        return this.column;
    }

    @Override
    public String getName() {
        return Spreadsheets.cellName(this.line.row, this.column);
    }

    public Map<?, ?> getChildren() {
        return Collections.emptyMap();
    }

    public Map<String, SheetNode> getProperties() {
        return this.properties;
    }

    public SpreadsheetBook getBook() {
        return this.line.getEngine().getBook();
    }

    public SpreadsheetEngine getEngine() {
        return this.line.getEngine();
    }

    public <T> T evaluate(SpreadsheetEvaluationEnvironment env) {
        return this.evaluate(env, null);
    }

    public <T> T evaluate(SpreadsheetEvaluationEnvironment env, CellValueVisitor caller) {
        if (caller != null) {
            caller.addReference(this.makeReferenceKey());
        }
        if (this.content instanceof SpreadsheetFormula) {
            SpreadsheetFormula f = (SpreadsheetFormula)this.content;
            if (f.result == null) {
                CellValueVisitor visitor = new CellValueVisitor(env, this);
                AstValue value = ((SpreadsheetFormula)this.content).value;
                if (this.inProgress) {
                    ++this.iterations;
                }
                if (!env.getBook().isIterationEnabled()) {
                    if (!this.inProgress) {
                        this.inProgress = true;
                        f.result = value.accept(visitor);
                    } else {
                        f.result = FormulaError2.CIRCULAR_REF.getString();
                    }
                } else if (this.iterations < env.iterationLimit) {
                    this.inProgress = true;
                    f.result = value.accept(visitor);
                } else if (f.result == null) {
                    f.result = 0.0;
                }
                env.getBook().registerReferences(this.makeReferenceKey(), visitor.getReferences());
            }
            this.inProgress = false;
            this.iterations = 0;
            return (T)f.result;
        }
        if (this.content instanceof SpreadsheetSCLConstant) {
            SpreadsheetSCLConstant sclConstant = (SpreadsheetSCLConstant)this.content;
            Object c = sclConstant.getContent();
            if (c instanceof Variant) {
                Variant cfr_ignored_0 = (Variant)c;
                return (T)c;
            }
            if (c instanceof ExternalRef) {
                ExternalRefData erd = env.getBook().getExternalRefValue(this.makeReferenceKey(), (ExternalRef)c);
                return (T)erd;
            }
            throw new IllegalStateException("Unsupported content " + String.valueOf(c));
        }
        this.inProgress = false;
        return (T)this.content;
    }

    public long makeReferenceKey() {
        SpreadsheetBook book = this.getBook();
        SpreadsheetEngine engine = this.getEngine();
        long engineIndex = book.getEngineIndex(engine);
        long row = this.line.row;
        long col = this.column;
        return (engineIndex << 40) + (row << 20) + col;
    }

    public void invalidate() {
        this.getEngine().rangeCache = null;
        if (this.content instanceof SpreadsheetFormula) {
            SpreadsheetFormula f = (SpreadsheetFormula)this.content;
            f.result = null;
        }
    }

    @Override
    public void accept(SpreadsheetVisitor v) {
        v.visit(this);
    }

    public Optional<SpreadsheetElement> getParent() {
        return Optional.of(this.line);
    }

    public List<SpreadsheetElement> getSpreadsheetChildren() {
        return Collections.emptyList();
    }

    public void remove(SpreadsheetElement child) {
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.column;
        result = 31 * result + (this.line == null ? 0 : this.line.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SpreadsheetCell other = (SpreadsheetCell)obj;
        if (this.column != other.column) {
            return false;
        }
        return !(this.line == null ? other.line != null : !this.line.equals(other.line));
    }

    public void setStyle(int styleId) {
        this.style = styleId;
    }

    public int getStyle() {
        return this.style;
    }

    public Object getContent() {
        return this.content;
    }

    public Variant getContentVariant(SpreadsheetBook book) {
        try {
            Object content = this.evaluate(SpreadsheetEvaluationEnvironment.getInstance(book));
            if (content == null) {
                return Variant.ofInstance((Object)"");
            }
            if (content instanceof Variant) {
                return (Variant)content;
            }
            if (content instanceof ExternalRefData) {
                return ((ExternalRefData)content).getContent();
            }
            return Variant.ofInstance(content);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return Variant.ofInstance((Object)t.toString());
        }
    }

    public SpreadsheetLine getLine() {
        return this.line;
    }

    public static SpreadsheetCell empty(SpreadsheetLine line, int column) {
        SpreadsheetCell cell = new SpreadsheetCell(line, column);
        cell.setContent("");
        cell.setStyle(SpreadsheetStyle.empty().getStyleId());
        return cell;
    }
}

