/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.project.management.install;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.provisional.p2.installer.IInstallOperation;
import org.eclipse.equinox.internal.provisional.p2.installer.InstallDescription;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class InstallDialog {
    private static final int BUTTON_WIDTH = 100;
    private static final int CANCEL = 1;
    private static final int OK = 0;
    private Button cancelButton;
    private Composite contents;
    private Button okButton;
    ProgressBar progressBar;
    Label progressSubTask;
    Label progressTask;
    int returnCode = -1;
    private Button settingsBrowse;
    private Label settingsExplain;
    private Composite settingsGroup;
    private Text settingsLocation;
    private Label settingsLocationLabel;
    private Button settingsShared;
    private Button settingsStandalone;
    private Shell shell;
    private boolean waitingForClose = false;
    private Button proxySettingsButton;
    private Button manualProxyTypeCheckBox;

    public InstallDialog() {
        this.createShell();
        this.progressTask = new Label(this.contents, 16448);
        this.progressTask.setLayoutData((Object)new GridData(768));
        this.createInstallSettingsControls();
        this.createProgressControls();
        this.createButtonBar();
        this.shell.pack();
        this.shell.layout();
        this.shell.open();
    }

    protected void browsePressed() {
        DirectoryDialog dirDialog = new DirectoryDialog(this.shell);
        dirDialog.setMessage("Select location");
        String location = dirDialog.open();
        if (location == null) {
            location = "";
        }
        this.settingsLocation.setText(location);
        this.validateInstallSettings();
    }

    protected void buttonPressed(int code) {
        this.returnCode = code;
        if (this.waitingForClose) {
            this.close();
        }
        if (code == 1 && !this.cancelButton.isDisposed()) {
            this.cancelButton.setEnabled(false);
        }
    }

    public void close() {
        if (this.shell == null) {
            return;
        }
        if (!this.shell.isDisposed()) {
            this.shell.dispose();
        }
        this.shell = null;
    }

    private void createButtonBar() {
        Composite buttonBar = new Composite(this.contents, 0);
        GridData data = new GridData(768);
        data.horizontalAlignment = 131072;
        buttonBar.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttonBar.setLayout((Layout)layout);
        this.okButton = new Button(buttonBar, 8);
        data = new GridData(100, -1);
        this.okButton.setLayoutData((Object)data);
        this.okButton.setText("Install");
        this.okButton.setEnabled(false);
        this.okButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InstallDialog.this.buttonPressed(0);
            }
        });
        this.cancelButton = new Button(buttonBar, 8);
        data = new GridData(100, -1);
        this.cancelButton.setLayoutData((Object)data);
        this.cancelButton.setText("Cancel");
        this.cancelButton.setEnabled(false);
        this.cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InstallDialog.this.buttonPressed(1);
            }
        });
    }

    private void createInstallSettingsControls() {
        this.settingsGroup = new Composite(this.contents, 0);
        GridLayout layout = new GridLayout();
        this.settingsGroup.setLayout((Layout)layout);
        this.settingsGroup.setLayoutData((Object)new GridData(1808));
        Listener validateListener = new Listener(){

            public void handleEvent(Event event) {
                InstallDialog.this.validateInstallSettings();
            }
        };
        Group installLocationGroup = new Group(this.settingsGroup, 0);
        installLocationGroup.setLayout((Layout)new GridLayout());
        installLocationGroup.setLayoutData((Object)new GridData(1808));
        installLocationGroup.setText("Location");
        this.settingsLocationLabel = new Label((Composite)installLocationGroup, 0);
        this.settingsLocationLabel.setLayoutData((Object)new GridData(768));
        this.settingsLocationLabel.setText("Location");
        Composite locationFieldGroup = new Composite((Composite)installLocationGroup, 0);
        locationFieldGroup.setLayoutData((Object)new GridData(1808));
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        locationFieldGroup.setLayout((Layout)layout);
        this.settingsLocation = new Text(locationFieldGroup, 2052);
        this.settingsLocation.setLayoutData((Object)new GridData(768));
        this.settingsLocation.addListener(24, validateListener);
        this.settingsLocation.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent event) {
                if (event.character == '\r' || event.character == '\u1000050') {
                    InstallDialog.this.buttonPressed(0);
                }
            }
        });
        this.settingsBrowse = new Button(locationFieldGroup, 8);
        this.settingsBrowse.setLayoutData((Object)new GridData(100, -1));
        this.settingsBrowse.setText("Browse");
        this.settingsBrowse.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                InstallDialog.this.browsePressed();
            }
        });
        Group installKindGroup = new Group(this.settingsGroup, 0);
        installKindGroup.setText("Layout");
        installKindGroup.setLayoutData((Object)new GridData(1808));
        installKindGroup.setLayout((Layout)new GridLayout());
        this.settingsStandalone = new Button((Composite)installKindGroup, 16);
        this.settingsStandalone.setText("Standalone");
        this.settingsStandalone.addListener(13, validateListener);
        this.settingsStandalone.setSelection(true);
        this.settingsShared = new Button((Composite)installKindGroup, 16);
        this.settingsShared.setText("Shared");
        this.settingsShared.addListener(13, validateListener);
        this.settingsExplain = new Label((Composite)installKindGroup, 64);
        GridData data = new GridData(-1, 40);
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this.settingsExplain.setLayoutData((Object)data);
        this.settingsExplain.setText("...");
        Group proxySettingsGroup = new Group(this.settingsGroup, 0);
        proxySettingsGroup.setLayout((Layout)new GridLayout());
        proxySettingsGroup.setLayoutData((Object)new GridData(1808));
        proxySettingsGroup.setText("Proxy");
        Composite proxySettingsFieldGroup = new Composite((Composite)proxySettingsGroup, 0);
        proxySettingsFieldGroup.setLayoutData((Object)new GridData(1808));
        layout = new GridLayout();
        layout.numColumns = 3;
        layout.makeColumnsEqualWidth = false;
        proxySettingsFieldGroup.setLayout((Layout)layout);
        this.manualProxyTypeCheckBox = new Button(proxySettingsFieldGroup, 32);
        this.manualProxyTypeCheckBox.setLayoutData((Object)new GridData(768));
        this.manualProxyTypeCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InstallDialog.this.openMessage("Failed to set proxy", 33);
            }
        });
        this.manualProxyTypeCheckBox.setText("Manual");
        this.proxySettingsButton = new Button(proxySettingsFieldGroup, 8);
        this.proxySettingsButton.setLayoutData((Object)new GridData(100, -1));
        this.proxySettingsButton.setText("Settings");
        this.proxySettingsButton.setEnabled(this.manualProxyTypeCheckBox.getSelection());
        this.proxySettingsButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                InstallDialog.this.openMessage("Failed to set proxy", 33);
            }
        });
        this.settingsGroup.setVisible(false);
    }

    private void createProgressControls() {
        this.progressBar = new ProgressBar(this.contents, 65792);
        this.progressBar.setLayoutData((Object)new GridData(768));
        this.progressBar.setVisible(false);
        this.progressSubTask = new Label(this.contents, 16448);
        this.progressSubTask.setLayoutData((Object)new GridData(768));
    }

    private void createShell() {
        this.shell = new Shell(67824);
        this.shell.setBounds(300, 200, 600, 400);
        this.shell.setText("Installer");
        this.shell.setLayout((Layout)new FillLayout());
        this.contents = new Composite((Composite)this.shell, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 15;
        layout.marginHeight = 15;
        this.contents.setLayout((Layout)layout);
    }

    public Display getDisplay() {
        Shell theShell = this.shell;
        if (theShell == null || theShell.isDisposed()) {
            return null;
        }
        return theShell.getDisplay();
    }

    public Shell getShell() {
        return this.shell;
    }

    public void promptForClose(String message) {
        Display display = this.getDisplay();
        if (display == null) {
            return;
        }
        this.progressTask.setText(message);
        this.progressSubTask.setText("");
        this.progressBar.setVisible(false);
        this.okButton.setVisible(false);
        this.cancelButton.setText("Close");
        this.cancelButton.setEnabled(true);
        this.waitingForClose = true;
        while (this.shell != null && !this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    public boolean promptForLaunch(InstallDescription description) {
        Display display = this.getDisplay();
        if (display == null) {
            return false;
        }
        this.progressTask.setText(NLS.bind((String)"Starting", (Object)description.getProductName()));
        this.progressSubTask.setText("");
        this.progressBar.setVisible(false);
        this.okButton.setText("Launch");
        this.okButton.setVisible(true);
        this.cancelButton.setText("Close");
        this.cancelButton.setVisible(true);
        this.waitingForClose = true;
        while (this.shell != null && !this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.returnCode == 0;
    }

    public void promptForLocations(InstallDescription description) {
        this.progressTask.setText(NLS.bind((String)"Location", (Object)description.getProductName()));
        this.okButton.setText("Install");
        this.okButton.setVisible(true);
        this.cancelButton.setText("Cancel");
        this.cancelButton.setEnabled(true);
        this.settingsGroup.setVisible(true);
        this.validateInstallSettings();
        Display display = this.getDisplay();
        this.returnCode = -1;
        while (this.returnCode == -1 && this.shell != null && !this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        if (this.returnCode == 1) {
            this.close();
        }
        if (this.shell == null || this.shell.isDisposed()) {
            throw new OperationCanceledException();
        }
        this.setInstallSettingsEnablement(false);
        Path location = new Path(this.settingsLocation.getText());
        description.setInstallLocation((IPath)location);
        if (this.settingsStandalone.getSelection()) {
            description.setAgentLocation(location.append("p2"));
            description.setBundleLocation((IPath)location);
        } else if (description.getAgentLocation() == null) {
            description.setAgentLocation(new Path(System.getProperty("user.home")).append(".p2/"));
        }
        this.okButton.setVisible(false);
    }

    public IStatus run(final IInstallOperation operation) {
        final Result result = new Result();
        Thread thread = new Thread(){

            @Override
            public void run() {
                block13: {
                    Display display;
                    block15: {
                        try {
                            result.setStatus(operation.install(new Monitor()));
                        }
                        catch (ThreadDeath t) {
                            throw t;
                        }
                        catch (RuntimeException t) {
                            result.failed(t);
                            Display display2 = InstallDialog.this.getDisplay();
                            if (display2 != null) {
                                display2.syncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                    }
                                });
                            }
                            result.done();
                            if (display2 != null) {
                                display2.wake();
                            }
                            break block13;
                        }
                        catch (Error t) {
                            Display display3;
                            block14: {
                                try {
                                    result.failed(t);
                                    display3 = InstallDialog.this.getDisplay();
                                    if (display3 == null) break block14;
                                }
                                catch (Throwable throwable) {
                                    Display display4 = InstallDialog.this.getDisplay();
                                    if (display4 != null) {
                                        display4.syncExec(new /* invalid duplicate definition of identical inner class */);
                                    }
                                    result.done();
                                    if (display4 != null) {
                                        display4.wake();
                                    }
                                    throw throwable;
                                }
                                display3.syncExec(new /* invalid duplicate definition of identical inner class */);
                            }
                            result.done();
                            if (display3 != null) {
                                display3.wake();
                            }
                            break block13;
                        }
                        display = InstallDialog.this.getDisplay();
                        if (display == null) break block15;
                        display.syncExec(new /* invalid duplicate definition of identical inner class */);
                    }
                    result.done();
                    if (display != null) {
                        display.wake();
                    }
                }
            }
        };
        this.waitingForClose = false;
        this.progressTask.setText("Installing");
        this.cancelButton.setText("Cancel");
        thread.start();
        Display display = this.getDisplay();
        while (!result.isDone()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return result.getStatus();
    }

    private void setInstallSettingsEnablement(boolean value) {
        this.settingsLocation.setEnabled(value);
        this.settingsShared.setEnabled(value);
        this.settingsStandalone.setEnabled(value);
        this.settingsGroup.setEnabled(value);
        this.settingsExplain.setEnabled(value);
        this.settingsBrowse.setEnabled(value);
        this.settingsLocationLabel.setEnabled(value);
    }

    public void setMessage(String message) {
        if (this.progressTask != null && !this.progressTask.isDisposed()) {
            this.progressTask.setText(message);
        }
    }

    void validateInstallSettings() {
        boolean enabled;
        boolean bl = enabled = this.settingsStandalone.getSelection() || this.settingsShared.getSelection();
        if (enabled &= Path.ROOT.isValidPath(this.settingsLocation.getText())) {
            Path location = new Path(this.settingsLocation.getText());
            enabled &= location.isAbsolute();
        }
        this.okButton.setEnabled(enabled);
        if (this.settingsStandalone.getSelection()) {
            this.settingsExplain.setText("Standalone...");
        } else {
            this.settingsExplain.setText("Shared...");
        }
    }

    private void openMessage(String msg, int style) {
        MessageBox messageBox = new MessageBox(Display.getDefault().getActiveShell(), style);
        messageBox.setMessage(msg);
        messageBox.open();
    }

    class Monitor
    implements IProgressMonitor {
        boolean canceled = false;
        boolean running = false;
        String subTaskName = "";
        double totalWork;
        double usedWork;

        Monitor() {
        }

        public void beginTask(String name, int work) {
            this.totalWork = work;
            this.running = true;
            this.update();
        }

        public void done() {
            this.running = false;
            this.usedWork = this.totalWork;
            this.update();
        }

        public void internalWorked(double work) {
            this.usedWork = Math.min(this.usedWork + work, this.totalWork);
            this.update();
        }

        public boolean isCanceled() {
            return InstallDialog.this.returnCode == 1;
        }

        public void setCanceled(boolean value) {
            InstallDialog.this.returnCode = 1;
        }

        public void setTaskName(String name) {
            this.subTaskName = name == null ? "" : name;
            this.update();
        }

        public void subTask(String name) {
            this.subTaskName = name == null ? "" : name;
            this.update();
        }

        void update() {
            Display display = InstallDialog.this.getDisplay();
            if (display == null) {
                return;
            }
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    Shell theShell = InstallDialog.this.getShell();
                    if (theShell == null || theShell.isDisposed()) {
                        return;
                    }
                    ((Monitor)Monitor.this).InstallDialog.this.progressSubTask.setText(this.shorten(Monitor.this.subTaskName));
                    if (((Monitor)Monitor.this).InstallDialog.this.progressBar.isDisposed()) {
                        return;
                    }
                    ((Monitor)Monitor.this).InstallDialog.this.progressBar.setVisible(Monitor.this.running);
                    ((Monitor)Monitor.this).InstallDialog.this.progressBar.setMaximum(1000);
                    ((Monitor)Monitor.this).InstallDialog.this.progressBar.setMinimum(0);
                    int value = (int)(Monitor.this.usedWork / Monitor.this.totalWork * 1000.0);
                    if (((Monitor)Monitor.this).InstallDialog.this.progressBar.getSelection() < value) {
                        ((Monitor)Monitor.this).InstallDialog.this.progressBar.setSelection(value);
                    }
                }

                private String shorten(String text) {
                    if (text.length() <= 64) {
                        return text;
                    }
                    int len = text.length();
                    return text.substring(0, 30) + "..." + text.substring(len - 30, len);
                }
            });
        }

        public void worked(int work) {
            this.internalWorked(work);
        }
    }

    static class Result {
        private boolean done;
        private IStatus status;

        Result() {
        }

        synchronized void done() {
            this.done = true;
        }

        synchronized void failed(Throwable t) {
            String msg = "Internal error";
            this.status = new Status(4, "org.simantics.project", msg, t);
        }

        synchronized IStatus getStatus() {
            return this.status;
        }

        synchronized boolean isDone() {
            return this.done;
        }

        public void setStatus(IStatus status) {
            this.status = status;
        }
    }
}

