/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.project.management;

import java.io.IOException;
import org.simantics.db.DatabaseUserAgent;
import org.simantics.db.Driver;
import org.simantics.db.Manager;
import org.simantics.db.exception.DatabaseException;
import org.simantics.project.management.ServerManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerManagerFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerManagerFactory.class);

    public static ServerManager create(String databaseDriverId, String address) throws IOException, DatabaseException {
        Driver driver = Manager.getDriver((String)databaseDriverId);
        if (driver == null) {
            throw new IllegalArgumentException("Database driver with ID " + databaseDriverId + " could not be found!");
        }
        LOGGER.info("ServerManagerFactory.create called with id {}, driver is {}.", (Object)databaseDriverId, (Object)driver);
        DatabaseUserAgent agent = Manager.getUserAgent((String)databaseDriverId);
        if (agent != null) {
            driver.setDatabaseUserAgent(address, agent);
        }
        return new ServerManager(driver);
    }
}

