/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.views.swt;

import org.eclipse.jface.viewers.ISelection;
import org.simantics.Simantics;
import org.simantics.browsing.ui.swt.widgets.impl.Widget;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupportImpl;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.AsyncReadGraph;
import org.simantics.db.Disposable;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.VirtualGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.procedure.AsyncListener;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.ReadInterface;
import org.simantics.db.request.WriteInterface;
import org.simantics.scenegraph.ontology.ScenegraphResources;
import org.simantics.ui.selection.AnyResource;
import org.simantics.ui.selection.AnyVariable;
import org.simantics.ui.selection.WorkbenchSelectionContentType;
import org.simantics.ui.selection.WorkbenchSelectionElement;
import org.simantics.utils.datastructures.Pair;
import org.simantics.utils.ui.ISelectionUtils;
import org.simantics.views.swt.ModelledView;

public class ModelledSupport
extends WidgetSupportImpl
implements Disposable {
    private final ModelledView view;
    private InputListener listener;
    private boolean disposed = false;
    private Pair<Variable, Resource> previous = null;

    public ModelledSupport(ModelledView view) {
        this.view = view;
    }

    public void dispose() {
        this.disposed = true;
        if (this.listener != null) {
            this.listener.dispose();
        }
    }

    public void fireInput(ISessionContext context, Object input) {
        this.lastInput = input;
        this.lastContext = context;
        if (this.listener != null) {
            this.listener.dispose();
        }
        if (context == null) {
            return;
        }
        Session session = context.peekSession();
        if (session == null) {
            return;
        }
        this.listener = new InputListener();
        if (this.view.runtime != null) {
            session.async((ReadInterface)new UniqueRead<Pair<Variable, Resource>>(){

                private Variable extractVariable(ReadGraph graph, ISelection selection) throws DatabaseException {
                    WorkbenchSelectionElement single = (WorkbenchSelectionElement)ISelectionUtils.filterSingleSelection((Object)selection, WorkbenchSelectionElement.class);
                    if (single != null) {
                        return (Variable)single.getContent((WorkbenchSelectionContentType)new AnyVariable((RequestProcessor)graph));
                    }
                    return (Variable)ISelectionUtils.filterSingleSelection((Object)((ISelection)ModelledSupport.this.lastInput), Variable.class);
                }

                private Resource extractResource(ReadGraph graph, ISelection selection) throws DatabaseException {
                    WorkbenchSelectionElement single = (WorkbenchSelectionElement)ISelectionUtils.filterSingleSelection((Object)selection, WorkbenchSelectionElement.class);
                    if (single != null) {
                        return (Resource)single.getContent((WorkbenchSelectionContentType)new AnyResource((RequestProcessor)graph));
                    }
                    return (Resource)ISelectionUtils.filterSingleSelection((Object)((ISelection)ModelledSupport.this.lastInput), Resource.class);
                }

                public Pair<Variable, Resource> perform(ReadGraph graph) throws DatabaseException {
                    Variable resultVariable = null;
                    Resource resultResource = null;
                    if (ModelledSupport.this.lastInput instanceof ISelection) {
                        Resource res;
                        Variable var = this.extractVariable(graph, (ISelection)ModelledSupport.this.lastInput);
                        if (var != null) {
                            resultVariable = var;
                        }
                        if ((res = this.extractResource(graph, (ISelection)ModelledSupport.this.lastInput)) != null) {
                            resultResource = res;
                        }
                    } else if (ModelledSupport.this.lastInput instanceof Resource) {
                        resultResource = (Resource)ModelledSupport.this.lastInput;
                    }
                    return Pair.make(resultVariable, resultResource);
                }
            }, (AsyncListener)this.listener);
        } else {
            for (Widget widget : this.widgets) {
                widget.setInput(context, input);
                for (Listener listener : this.listeners) {
                    listener.execute(input);
                }
            }
        }
    }

    class InputListener
    implements AsyncListener<Pair<Variable, Resource>> {
        private boolean disposed = false;

        InputListener() {
        }

        public boolean isDisposed() {
            return this.disposed || ModelledSupport.this.disposed;
        }

        public void dispose() {
            this.disposed = true;
        }

        public String toString() {
            return "InputListener@ModelledSupport@" + String.valueOf((Object)ModelledSupport.this.view);
        }

        public void execute(AsyncReadGraph graph, final Pair<Variable, Resource> result) {
            if (ModelledSupport.this.previous != null && ModelledSupport.this.previous.equals(result)) {
                return;
            }
            ModelledSupport.this.previous = result;
            graph.getSession().async((WriteInterface)new WriteRequest((VirtualGraph)Simantics.getSession().getService(VirtualGraph.class)){

                public void perform(WriteGraph graph) throws DatabaseException {
                    ScenegraphResources SG = ScenegraphResources.getInstance((ReadGraph)graph);
                    Resource runtime = ((InputListener)InputListener.this).ModelledSupport.this.view.runtime;
                    if (result.first != null) {
                        String uri = ((Variable)result.first).getURI((ReadGraph)graph);
                        graph.claimLiteral(runtime, SG.Runtime_HasVariable, (Object)uri, (Binding)Bindings.STRING);
                    } else {
                        graph.deny(runtime, SG.Runtime_HasVariable);
                    }
                    if (result.second != null) {
                        graph.deny(runtime, SG.Runtime_HasResource);
                        graph.claim(runtime, SG.Runtime_HasResource, (Resource)result.second);
                    } else {
                        graph.deny(runtime, SG.Runtime_HasResource);
                    }
                    ((InputListener)InputListener.this).ModelledSupport.this.view.fireInput();
                }
            });
        }

        public void exception(AsyncReadGraph graph, Throwable throwable) {
            Logger.defaultLogError((Throwable)throwable);
        }
    }
}

