/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.threads.internal;

import java.lang.reflect.Array;

public class ListenerList<T> {
    private volatile T[] array;
    private final Class<T> componentType;

    public ListenerList(Class<T> componentType) {
        this.componentType = componentType;
        this.array = this.createArray(0);
    }

    public T[] getListeners() {
        return this.array;
    }

    public synchronized void add(T listener) {
        int oldLength = this.array.length;
        int newLength = oldLength + 1;
        T[] newArray = this.createArray(newLength);
        System.arraycopy(this.array, 0, newArray, 0, oldLength);
        newArray[oldLength] = listener;
        this.array = newArray;
    }

    public synchronized boolean remove(T listener) {
        int pos = this.getPos(listener);
        if (pos < 0) {
            return false;
        }
        int oldLength = this.array.length;
        int newLength = oldLength - 1;
        T[] newArray = this.createArray(newLength);
        if (pos > 0) {
            System.arraycopy(this.array, 0, newArray, 0, pos);
        }
        if (pos < newLength) {
            System.arraycopy(this.array, pos + 1, newArray, pos, newLength - pos);
        }
        this.array = newArray;
        return true;
    }

    private synchronized int getPos(T listener) {
        int i = 0;
        while (i < this.array.length) {
            if (this.array[i] == listener) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int size() {
        return this.array.length;
    }

    public boolean isEmpty() {
        return this.array.length == 0;
    }

    public void clear() {
        this.array = this.createArray(0);
    }

    private T[] createArray(int size) {
        return (Object[])Array.newInstance(this.componentType, size);
    }
}

