/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.datastructures.map;

public final class Associativity {
    public int dimensionAssociativity;
    public int level;

    public static Associativity of(boolean ... dimensionAssociativity) {
        return new Associativity(dimensionAssociativity);
    }

    public static Associativity[] fullAssociativity(int level) {
        int count = (1 << level) - 1;
        Associativity[] result = new Associativity[count];
        int i = 0;
        while (i < count) {
            result[i] = new Associativity(level, i);
            ++i;
        }
        return result;
    }

    public Associativity(boolean ... dimensionAssociativity) {
        if (dimensionAssociativity == null || dimensionAssociativity.length > 32) {
            throw new IllegalArgumentException();
        }
        int mask = 1;
        boolean[] blArray = dimensionAssociativity;
        int n = dimensionAssociativity.length;
        int n2 = 0;
        while (n2 < n) {
            boolean b = blArray[n2];
            if (b) {
                this.dimensionAssociativity |= mask;
            }
            mask <<= 1;
            ++n2;
        }
        this.level = dimensionAssociativity.length;
    }

    public Associativity(int level, int dimensionAssociativity) {
        this.dimensionAssociativity = dimensionAssociativity;
        this.level = level;
    }

    public int hashCode() {
        return this.dimensionAssociativity;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        Associativity other = (Associativity)obj;
        return this.dimensionAssociativity == other.dimensionAssociativity;
    }

    public int getLevel() {
        return this.level;
    }
}

