/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.datastructures.map;

import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.simantics.utils.datastructures.map.Associativity;
import org.simantics.utils.datastructures.map.Tuple;

public class AssociativeMap {
    int level;
    THashMap<Tuple, THashSet<Tuple>>[] maps;
    Tuple tupleQueryAllTuples;
    Associativity[] associativities;

    public AssociativeMap(Associativity ... associativenesses) {
        if (associativenesses == null) {
            throw new NullPointerException();
        }
        if (associativenesses.length == 0) {
            throw new IllegalArgumentException();
        }
        this.associativities = associativenesses;
        this.level = associativenesses[0].getLevel();
        int i = 1;
        while (i < associativenesses.length) {
            if (associativenesses[i].getLevel() != this.level) {
                throw new IllegalArgumentException("Levels are different");
            }
            ++i;
        }
        int count = (1 << this.level) - 1;
        this.maps = new THashMap[count];
        Associativity[] associativityArray = associativenesses;
        int n = associativenesses.length;
        int n2 = 0;
        while (n2 < n) {
            Associativity a = associativityArray[n2];
            int associativity = a.dimensionAssociativity;
            if (associativity == count) {
                associativity = 0;
            }
            if (this.maps[associativity] == null) {
                THashMap map;
                this.maps[associativity] = map = new THashMap();
            }
            ++n2;
        }
        this.tupleQueryAllTuples = new Tuple(new Object[this.level]);
    }

    public void add(Collection<Tuple> stms) {
        int associativity = 0;
        while (associativity < this.maps.length) {
            THashMap<Tuple, THashSet<Tuple>> map = this.maps[associativity];
            if (map != null) {
                for (Tuple stm : stms) {
                    if (!stm.isFull()) {
                        throw new IllegalArgumentException("Tuple Query cannot be added.");
                    }
                    Tuple tupleQuery = AssociativeMap.createTupleQuery(stm, associativity);
                    THashSet set = (THashSet)map.get((Object)tupleQuery);
                    if (set == null) {
                        set = new THashSet();
                        map.put((Object)tupleQuery, (Object)set);
                    }
                    set.add((Object)stm);
                }
            }
            ++associativity;
        }
    }

    public void add(Tuple ... stms) {
        int associativity = 0;
        while (associativity < this.maps.length) {
            THashMap<Tuple, THashSet<Tuple>> map = this.maps[associativity];
            if (map != null) {
                Tuple[] tupleArray = stms;
                int n = stms.length;
                int n2 = 0;
                while (n2 < n) {
                    Tuple stm = tupleArray[n2];
                    if (!stm.isFull()) {
                        throw new IllegalArgumentException("Tuple Query cannot be added.");
                    }
                    Tuple tupleQuery = AssociativeMap.createTupleQuery(stm, associativity);
                    THashSet set = (THashSet)map.get((Object)tupleQuery);
                    if (set == null) {
                        set = new THashSet();
                        map.put((Object)tupleQuery, (Object)set);
                    }
                    set.add((Object)stm);
                    ++n2;
                }
            }
            ++associativity;
        }
    }

    public void remove(Collection<Tuple> stms) {
        int associativity = 0;
        while (associativity < this.maps.length) {
            THashMap<Tuple, THashSet<Tuple>> map = this.maps[associativity];
            if (map != null) {
                for (Tuple stm : stms) {
                    Tuple tupleQuery = AssociativeMap.createTupleQuery(stm, associativity);
                    THashSet set = (THashSet)map.get((Object)tupleQuery);
                    if (set == null) continue;
                    set.remove((Object)stm);
                }
            }
            ++associativity;
        }
    }

    public Collection<Tuple> get(Tuple tupleQuery, Collection<Tuple> result) throws UnsupportedOperationException {
        if (tupleQuery == null || tupleQuery.getLevel() != this.level) {
            throw new IllegalArgumentException();
        }
        if (tupleQuery.associativity == this.maps.length) {
            THashMap<Tuple, THashSet<Tuple>> map = this.maps[0];
            if (map == null) {
                throw new UnsupportedOperationException();
            }
            THashSet set = (THashSet)map.get((Object)this.tupleQueryAllTuples);
            if (result == null) {
                if (set != null && set.contains((Object)tupleQuery)) {
                    return Collections.singleton(tupleQuery);
                }
                return Collections.emptySet();
            }
            if (set.contains((Object)tupleQuery)) {
                result.add(tupleQuery);
            }
            return result;
        }
        THashMap<Tuple, THashSet<Tuple>> map = this.maps[tupleQuery.associativity];
        if (map == null) {
            throw new UnsupportedOperationException();
        }
        THashSet set = (THashSet)map.get((Object)tupleQuery);
        if (set == null) {
            return Collections.emptySet();
        }
        if (result == null) {
            result = new ArrayList<Tuple>(set.size());
        }
        for (Tuple t : set) {
            result.add(t);
        }
        return result;
    }

    public Associativity[] getAssociativities() {
        return this.associativities;
    }

    private static Tuple createTupleQuery(Tuple tuple, int associativity) {
        if (tuple.associativity == associativity) {
            return tuple;
        }
        int mask = 1;
        int level = tuple.getLevel();
        Object[] fields = new Object[level];
        int i = 0;
        while (i < level) {
            if ((associativity & mask) > 0) {
                fields[i] = tuple.getField(i);
            }
            mask <<= 1;
            ++i;
        }
        return new Tuple(fields);
    }

    public int getLevel() {
        return this.level;
    }
}

