/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.utils.imports;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ResourceNotFoundException;
import org.simantics.db.layer0.adapter.impl.DefaultPasteImportAdvisor;
import org.simantics.graph.representation.Root;
import org.simantics.layer0.Layer0;

public class SysdynFunctionLibraryImportAdvisor
extends DefaultPasteImportAdvisor {
    public SysdynFunctionLibraryImportAdvisor(Resource library) {
        super(library);
    }

    public void analyzeType(ReadGraph graph, Root root) throws DatabaseException {
        if (root.type.equals("http://www.simantics.org/Sysdyn-1.1/SharedFunctionOntology")) {
            try {
                this.library = graph.getResource("http://SharedOntologies");
            }
            catch (ResourceNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    public Resource createRoot(WriteOnlyGraph graph, Root root) throws DatabaseException {
        Layer0 l0 = (Layer0)graph.getService(Layer0.class);
        Resource rootResource = graph.newResource();
        graph.claim(this.library, l0.ConsistsOf, l0.PartOf, rootResource);
        String name = root.name;
        String newName = (String)this.nameMappings.get(name);
        graph.addLiteral(rootResource, l0.HasName, l0.NameOf, l0.String, (Object)newName, (Binding)Bindings.STRING);
        this.addRootInfo(root, newName, rootResource);
        return rootResource;
    }
}

