/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.representation.utils;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.simantics.sysdyn.expressionParser.ExpressionParser;
import org.simantics.sysdyn.expressionParser.ParseException;
import org.simantics.sysdyn.expressionParser.Token;
import org.simantics.sysdyn.representation.Enumeration;
import org.simantics.sysdyn.representation.EnumerationIndex;
import org.simantics.sysdyn.representation.Variable;
import org.simantics.sysdyn.representation.utils.RepresentationUtils;

public class IndexUtils {
    public static int indexOf(Enumeration enumeration, String index) {
        int result = -1;
        ArrayList<EnumerationIndex> indexes = enumeration.getEnumerationIndexes();
        int i = 0;
        while (i < indexes.size()) {
            if (indexes.get(i).getName().equals(index)) {
                result = i + 1;
                break;
            }
            ++i;
        }
        return result;
    }

    public static String rangeToIndexes(Variable variable, String range) {
        if (variable == null) {
            return range;
        }
        StringBuilder sb = new StringBuilder();
        if (variable.getArrayIndexes() == null || range == null) {
            return "";
        }
        ArrayList<Enumeration> enumerations = variable.getArrayIndexes();
        StringTokenizer st = new StringTokenizer(range, "{}[]:,", true);
        int index = 0;
        boolean insideCurlyBrackets = false;
        while (st.hasMoreTokens()) {
            String rangeToken = st.nextToken().trim();
            if (rangeToken.matches("[\\[\\]:]")) {
                sb.append(rangeToken);
                continue;
            }
            if (rangeToken.matches("[\\{]")) {
                sb.append(rangeToken);
                insideCurlyBrackets = true;
                continue;
            }
            if (rangeToken.matches("[\\}]")) {
                sb.append(rangeToken);
                insideCurlyBrackets = false;
                continue;
            }
            if (rangeToken.equals(",")) {
                sb.append(rangeToken);
                if (insideCurlyBrackets) continue;
                ++index;
                continue;
            }
            if (index < enumerations.size()) {
                if (rangeToken.equals(enumerations.get(index).getName())) {
                    sb.append(":");
                    continue;
                }
                int i = IndexUtils.indexOf(enumerations.get(index), rangeToken);
                if (i >= 0) {
                    sb.append(i);
                    continue;
                }
                sb.append(rangeToken);
                continue;
            }
            sb.append(rangeToken);
        }
        return sb.toString();
    }

    private static String fixForRangeEnumerations(Variable variable, String equation) {
        ExpressionParser parser = new ExpressionParser(new StringReader(equation));
        try {
            parser.expr();
            for (ExpressionParser.ForRange forRange : parser.getForRanges()) {
                Object rangeString = new String(forRange.start.image);
                Token temp = forRange.start;
                while (!temp.equals(forRange.end)) {
                    temp = temp.next;
                    rangeString = (String)rangeString + " " + temp.image;
                }
                Variable v = RepresentationUtils.getVariable(variable.getParentConfiguration(), (String)rangeString);
                if (!(v instanceof Enumeration)) continue;
                equation = equation.replaceAll("in[\\s]*" + (String)rangeString + "($|[^\\.])", "in " + ((String)rangeString).replaceAll(" ", "_") + ".elements$1");
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return equation;
    }

    public static String equationRangesToIndexes(Variable variable, String equation) {
        if (equation == null) {
            return equation;
        }
        if (equation.contains("[")) {
            StringBuilder result = new StringBuilder();
            String delimiters = "+-*/(){}[],. ";
            StringTokenizer st = new StringTokenizer(equation, delimiters, true);
            String prevToken = st.nextToken();
            result.append(prevToken);
            while (st.hasMoreTokens()) {
                String nextToken = st.nextToken();
                if (nextToken.equals("[")) {
                    StringBuilder range = new StringBuilder();
                    range.append("[");
                    String rangeToken = st.nextToken();
                    while (!rangeToken.equals("]")) {
                        range.append(rangeToken);
                        rangeToken = st.nextToken();
                    }
                    range.append("]");
                    Variable prevVar = RepresentationUtils.getVariable(variable.getParentConfiguration(), prevToken.trim());
                    result.append(IndexUtils.rangeToIndexes(prevVar, range.toString()));
                } else {
                    result.append(nextToken);
                }
                prevToken = nextToken;
            }
            equation = IndexUtils.fixForRangeEnumerations(variable, result.toString());
        } else if (equation.contains("{")) {
            equation = IndexUtils.fixForRangeEnumerations(variable, equation);
        }
        return equation;
    }
}

