/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.representation;

import java.util.ArrayList;
import org.simantics.objmap.annotations.GraphType;
import org.simantics.objmap.annotations.RelatedElements;
import org.simantics.sysdyn.representation.Flow;
import org.simantics.sysdyn.representation.IElement;
import org.simantics.sysdyn.representation.IndependentVariable;
import org.simantics.sysdyn.representation.Valve;
import org.simantics.sysdyn.representation.Variability;
import org.simantics.sysdyn.representation.expressions.StockExpression;
import org.simantics.sysdyn.representation.utils.SheetFormatUtils;
import org.simantics.sysdyn.representation.visitors.IElementVisitorVoid;

@GraphType(value="http://www.simantics.org/Sysdyn-1.1/Stock")
public class Stock
extends IndependentVariable {
    @RelatedElements(value="http://www.simantics.org/Sysdyn-1.1/Variable/isHeadOf", composition=true)
    private ArrayList<IElement> incomingConnections = new ArrayList();
    @RelatedElements(value="http://www.simantics.org/Sysdyn-1.1/Variable/isTailOf", composition=true)
    private ArrayList<IElement> outgoingConnections = new ArrayList();

    @Override
    public void accept(IElementVisitorVoid v) {
        v.visit(this);
    }

    @Override
    public String getInitialEquation() {
        if (Variability.getVariability(this) == Variability.CONTINUOUS) {
            return super.getInitialEquation();
        }
        return null;
    }

    @Override
    public String getDeclaration() {
        String each;
        String string = each = this.getArrayIndexes() != null && !this.getArrayIndexes().isEmpty() ? "each " : "";
        if (Variability.getVariability(this) == Variability.CONTINUOUS) {
            return "    " + this.getType() + " " + this.getModelicaName() + this.getRange() + "(" + each + "fixed=false);\n";
        }
        StockExpression e = (StockExpression)this.getExpressions().get(0);
        String initialEquation = e.getModelicaExpression();
        initialEquation = SheetFormatUtils.reformatSheetReferences(this, initialEquation);
        return "    " + this.getType() + " " + this.getModelicaName() + this.getRange() + "(start=" + initialEquation + ", " + each + "fixed=true);\n";
    }

    @Override
    public String getEquation() {
        return this.getVariableEquation();
    }

    public ArrayList<Valve> getIncomingValves() {
        ArrayList<Valve> valves = new ArrayList<Valve>();
        for (IElement element : this.incomingConnections) {
            if (!(element instanceof Flow)) continue;
            Flow flow = (Flow)element;
            valves.add((Valve)flow.getTail());
        }
        return valves;
    }

    public ArrayList<Valve> getOutgoingValves() {
        ArrayList<Valve> valves = new ArrayList<Valve>();
        for (IElement element : this.outgoingConnections) {
            if (!(element instanceof Flow)) continue;
            Flow flow = (Flow)element;
            valves.add((Valve)flow.getHead());
        }
        return valves;
    }
}

