/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.representation;

import java.util.ArrayList;
import org.simantics.objmap.annotations.GraphType;
import org.simantics.objmap.annotations.RelatedElements;
import org.simantics.objmap.annotations.RelatedListElements;
import org.simantics.objmap.annotations.RelatedValue;
import org.simantics.sysdyn.representation.EnumerationIndex;
import org.simantics.sysdyn.representation.Redeclaration;
import org.simantics.sysdyn.representation.Variable;
import org.simantics.sysdyn.representation.visitors.IElementVisitorVoid;

@GraphType(value="http://www.simantics.org/Sysdyn-1.1/Enumeration")
public class Enumeration
extends Variable {
    @RelatedListElements(value="http://www.simantics.org/Sysdyn-1.1/Enumeration/enumerationIndexList")
    private ArrayList<EnumerationIndex> enumerationIndexes = new ArrayList();
    @RelatedValue(value="http://www.simantics.org/Sysdyn-1.1/Enumeration/isReplaceable")
    private Boolean isReplaceable;
    @RelatedElements(value="http://www.simantics.org/Sysdyn-1.1/Redeclaration/replacedEnumeration/Inverse", composition=true)
    private ArrayList<Redeclaration> redeclarations = new ArrayList();

    @Override
    public void accept(IElementVisitorVoid v) {
        v.visit(this);
    }

    public String getDeclaration() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getEnumerationClassDefinition());
        sb.append("    ");
        sb.append(this.getModelicaName() + "_class");
        sb.append(" " + this.getModelicaName());
        sb.append(";\n");
        sb.append("    parameter Integer " + this.getModelicaName() + "_size = " + this.getModelicaName() + ".size;\n");
        sb.append("    parameter Integer " + this.getModelicaName() + "_elements[:] = " + this.getModelicaName() + ".elements;\n");
        return sb.toString();
    }

    public ArrayList<EnumerationIndex> getEnumerationIndexes() {
        return this.enumerationIndexes;
    }

    public boolean isReplaceable() {
        return Boolean.TRUE.equals(this.isReplaceable);
    }

    public String getEnumerationClassDefinition() {
        ArrayList<EnumerationIndex> indexes = this.getEnumerationIndexes();
        StringBuilder elementsBuilder = new StringBuilder();
        elementsBuilder.append("{");
        StringBuilder indexesBuilder = new StringBuilder();
        int i = 1;
        while (i <= indexes.size()) {
            indexesBuilder.append("        constant Integer ");
            indexesBuilder.append(indexes.get(i - 1).getModelicaName());
            indexesBuilder.append(" = " + i + ";\n");
            elementsBuilder.append(i);
            if (i < indexes.size()) {
                elementsBuilder.append(",");
            }
            ++i;
        }
        elementsBuilder.append("}");
        StringBuilder sb = new StringBuilder();
        sb.append("    class ");
        sb.append(this.getModelicaName());
        sb.append("_class\n");
        sb.append("        extends Enumeration_class(size=");
        sb.append(indexes.size());
        sb.append(", elements=");
        sb.append((CharSequence)elementsBuilder);
        sb.append(");\n");
        sb.append((CharSequence)indexesBuilder);
        sb.append("    end ");
        sb.append(this.getModelicaName());
        sb.append("_class;\n");
        return sb.toString();
    }

    public ArrayList<Redeclaration> getRedeclarations() {
        return this.redeclarations;
    }
}

