/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.nodemanager;

import java.util.HashMap;
import java.util.Map;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.IndexRoot;
import org.simantics.db.common.utils.CommonDBUtils;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.db.service.SerialisationSupport;
import org.simantics.simulator.toolkit.StandardRealm;
import org.simantics.simulator.toolkit.db.StandardVariableSessionManager;
import org.simantics.sysdyn.manager.SysdynExperiment;
import org.simantics.sysdyn.nodemanager.SysdynEngine;
import org.simantics.sysdyn.nodemanager.SysdynVariableNode;
import org.simantics.sysdyn.nodemanager.SysdynVariableRealm;
import org.simantics.sysdyn.solver.SolverSettings;
import org.simantics.sysdyn.solver.Solvers;

public class SysdynVariableSessionManager
extends StandardVariableSessionManager<SysdynVariableNode, SysdynEngine> {
    private static SysdynVariableSessionManager INSTANCE;
    private Map<String, SysdynVariableRealm> realms = new HashMap<String, SysdynVariableRealm>();
    private Map<String, String> experimentToRealm = new HashMap<String, String>();

    public static SysdynVariableSessionManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new SysdynVariableSessionManager();
        }
        return INSTANCE;
    }

    public static Resource getRunResource(ReadGraph graph, String id) throws DatabaseException {
        SerialisationSupport ss = (SerialisationSupport)graph.getService(SerialisationSupport.class);
        Long l = Long.parseLong(id);
        return ss.getResource(l.longValue());
    }

    public static String getRunId(ReadGraph graph, Resource run) throws DatabaseException {
        SerialisationSupport ss = (SerialisationSupport)graph.getService(SerialisationSupport.class);
        return Long.toString(ss.getRandomAccessId(run));
    }

    protected SysdynEngine createEngine(ReadGraph graph, String id) throws DatabaseException {
        Resource run = SysdynVariableSessionManager.getRunResource(graph, id);
        String uuid = NameUtils.getSafeName((ReadGraph)graph, (Resource)run);
        Resource experiment = CommonDBUtils.getPossibleOwner((ReadGraph)graph, (Resource)run);
        Resource model = (Resource)graph.syncRequest((Read)new IndexRoot(experiment));
        try {
            SysdynExperiment exp = Solvers.getExperiment(graph, SolverSettings.getSelectedSolverType(), experiment, model, uuid);
            SysdynVariableSessionManager.getInstance().mapExperimentToRealm(exp.getIdentifier(), id);
            return new SysdynEngine(graph, exp, run);
        }
        catch (Exception e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    synchronized void mapExperimentToRealm(String experimentId, String realmId) {
        this.experimentToRealm.put(experimentId, realmId);
    }

    synchronized SysdynVariableRealm getRealmByExperiment(String experimentId) {
        String realmId = this.experimentToRealm.get(experimentId);
        if (realmId == null) {
            return null;
        }
        return this.realms.get(realmId);
    }

    protected synchronized StandardRealm<SysdynVariableNode, SysdynEngine> createRealm(SysdynEngine engine, String id) {
        SysdynVariableRealm result = new SysdynVariableRealm(engine, id);
        this.realms.put(id, result);
        return result;
    }

    public static void refreshVariablesByExperiment(String experimentId) {
        SysdynVariableRealm realm = SysdynVariableSessionManager.getInstance().getRealmByExperiment(experimentId);
        if (realm != null) {
            realm.getNodeManager().refreshVariables();
        }
    }
}

