/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.modelImport.model.expression;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.modelImport.model.WriteContext;
import org.simantics.sysdyn.modelImport.model.expression.Expression;

public class NormalExpression
extends Expression {
    private String expression;

    public NormalExpression(String expression) {
        this.expression = expression;
    }

    @Override
    public Resource write(WriteGraph graph, Resource parent, WriteContext context) throws DatabaseException {
        SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
        Resource expr = super.write(graph, parent, context);
        graph.claimLiteral(expr, sr.Expression_equation, (Object)this.expression, (Binding)Bindings.STRING);
        return expr;
    }

    @Override
    public Resource getExpressionType(ReadGraph graph) {
        try {
            Double.parseDouble(this.expression);
            return SysdynResource.getInstance((ReadGraph)graph).ParameterExpression;
        }
        catch (NumberFormatException e) {
            return SysdynResource.getInstance((ReadGraph)graph).NormalExpression;
        }
    }

    @Override
    public String getExpressionTypeString() {
        try {
            Double.parseDouble(this.expression);
            return "ParameterExpression";
        }
        catch (NumberFormatException e) {
            return "NormalExpression";
        }
    }
}

