/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.modelImport.model.expression;

import java.util.ArrayList;
import java.util.List;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.utils.ListUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.modelImport.model.WriteContext;
import org.simantics.sysdyn.modelImport.model.expression.Expression;
import org.simantics.sysdyn.modelImport.model.support.Enumeration;

public class EnumerationExpression
extends Expression {
    private List<Enumeration> enumerations;
    private List<EnumerationSubExpression> subExpressions;

    public EnumerationExpression(List<Enumeration> enumerations) {
        this.enumerations = enumerations;
        this.subExpressions = new ArrayList<EnumerationSubExpression>();
    }

    public void addExpression(Expression expression, String ... indices) {
        this.subExpressions.add(new EnumerationSubExpression(expression, indices));
    }

    @Override
    public Resource write(WriteGraph graph, Resource parent, WriteContext context) throws DatabaseException {
        SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
        for (EnumerationSubExpression subexpr : this.subExpressions) {
            StringBuilder range = new StringBuilder();
            range.append('[');
            int i = 0;
            while (i < subexpr.indices.length) {
                if (i > 0) {
                    range.append(',');
                }
                range.append(subexpr.indices[i]);
                ++i;
            }
            range.append(']');
            Resource res = subexpr.expression.write(graph, parent, context);
            graph.claimLiteral(res, sr.Expression_arrayRange, (Object)range.toString(), (Binding)Bindings.STRING);
        }
        ArrayList<Resource> indexlist = new ArrayList<Resource>();
        for (Enumeration enumeration : this.enumerations) {
            indexlist.add(enumeration.getResource());
        }
        graph.claim(parent, sr.Variable_arrayIndexesList, ListUtils.create((WriteGraph)graph, indexlist));
        return this.getResource();
    }

    @Override
    public Resource getExpressionType(ReadGraph graph) {
        return this.subExpressions.get((int)0).expression.getExpressionType(graph);
    }

    @Override
    public String getExpressionTypeString() {
        return this.subExpressions.get((int)0).expression.getExpressionTypeString();
    }

    @Override
    public Resource getResource() {
        return this.subExpressions.get((int)0).expression.getResource();
    }

    private class EnumerationSubExpression {
        Expression expression;
        String[] indices;

        public EnumerationSubExpression(Expression expression, String ... indices) {
            this.expression = expression;
            this.indices = indices;
        }
    }
}

