/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.modelImport.mdl;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.simantics.sysdyn.modelImport.MdlUtil;
import org.simantics.sysdyn.modelImport.mdl.MdlModel;
import org.simantics.sysdyn.modelImport.mdl.MdlVariable;
import org.simantics.sysdyn.modelImport.mdl.Subscript;
import org.simantics.sysdyn.modelImport.model.expression.EnumerationExpression;
import org.simantics.sysdyn.modelImport.model.expression.NormalExpression;
import org.simantics.sysdyn.modelImport.model.support.Enumeration;

public class SubscriptVariable
extends MdlVariable {
    private static final String SUBSCRIPT_VARIABLE_DECL = "([A-Za-z]\\w*(?:\\s+\\w+)*|\"[^\"\\\\]*(?:\\\\.[^\"\\\\]*)*\")\\[([A-Za-z]\\w*(?:\\s+\\w+)*\\!?(?:,[A-Za-z]\\w*(?:\\s+\\w+)*\\!?)*)\\](?:\\s*=\\s*([^~]*?(?:\"[^\"\\\\]*(?:\\\\.[^\"\\\\]*)*\"[^~]*?)*))?(\\s*~\\s*([^~]*?)\\s*~\\s*([^\\|]*?)\\s*\\|)";
    private static final int subscriptVariableName = 1;
    private static final int subscriptVariableIndices = 2;
    private static final int subscriptVariableExpression = 3;
    private static final int subscriptVariableSuffix = 4;
    private String[] indices;
    private SubscriptVariable next;

    protected SubscriptVariable(String name, MdlModel mdl, String expression, String[] indices) {
        super(name, mdl, expression);
        this.indices = indices;
        this.next = null;
    }

    public static SubscriptVariable getPossible(String line, MdlModel mdl) throws Exception {
        Matcher matcher = Pattern.compile(SUBSCRIPT_VARIABLE_DECL).matcher(line);
        if (!matcher.matches()) {
            return null;
        }
        String name = MdlUtil.normalize(matcher.group(1));
        String[] indices = MdlUtil.normalize(matcher.group(2)).split(",");
        String expression = matcher.group(3);
        if (expression != null) {
            expression = MdlUtil.normalize(expression);
        }
        SubscriptVariable subVar = new SubscriptVariable(name, mdl, expression, indices);
        subVar.parseSuffix(matcher.group(4));
        return subVar;
    }

    public String[] getIndices() {
        return this.indices;
    }

    private SubscriptVariable getNext() {
        return this.next;
    }

    private void setNext(SubscriptVariable next) {
        this.next = next;
    }

    public void addSubscriptVariable(SubscriptVariable variable) {
        SubscriptVariable last = this;
        while (last.getNext() != null) {
            last = last.getNext();
        }
        last.setNext(variable);
    }

    @Override
    public EnumerationExpression getExpression() {
        EnumerationExpression expr;
        ArrayList<Enumeration> enumerations;
        SubscriptVariable var;
        block23: {
            ArrayList subscripts = new ArrayList();
            int i = 0;
            while (i < this.indices.length) {
                subscripts.add(new HashSet());
                ++i;
            }
            var = this;
            while (var != null) {
                i = 0;
                while (i < var.getIndices().length) {
                    ((Set)subscripts.get(i)).add(var.getIndices()[i]);
                    ++i;
                }
                var = var.getNext();
            }
            enumerations = new ArrayList<Enumeration>();
            for (Set set : subscripts) {
                Subscript potential = this.getMdl().resolveSubscript(set);
                if (potential == null) {
                    System.err.println("subscript indices could not be resolved ");
                    return null;
                }
                enumerations.add(potential.getEnumeration());
            }
            String string = this.getExpressionString().replaceAll(" ", "");
            if (this.next == null) {
                if (enumerations.size() == 1 && Pattern.matches("[+-]?(?:NaN|Infinity|\\d+(?:\\.\\d+)?(?:[eE][+-]?\\d+)?)(,[+-]?(?:NaN|Infinity|\\d+(?:\\.\\d+)?(?:[eE][+-]?\\d+)?))*", string)) {
                    expr = new EnumerationExpression(enumerations);
                    String[] values = string.split(",");
                    if (((Enumeration)enumerations.get(0)).getValues().size() == values.length) {
                        int i2 = 0;
                        while (i2 < values.length) {
                            expr.addExpression(new NormalExpression(values[i2]), ((Enumeration)enumerations.get(0)).getValues().get(i2));
                            ++i2;
                        }
                        return expr;
                    }
                } else if (enumerations.size() == 2 && Pattern.matches("([+-]?(?:NaN|Infinity|\\d+(?:\\.\\d+)?(?:[eE][+-]?\\d+)?)(,[+-]?(?:NaN|Infinity|\\d+(?:\\.\\d+)?(?:[eE][+-]?\\d+)?))*;)+", string)) {
                    expr = new EnumerationExpression(enumerations);
                    String[] rows = string.split(";");
                    if (((Enumeration)enumerations.get(0)).getValues().size() == rows.length) {
                        int i3 = 0;
                        while (i3 < rows.length) {
                            String[] values = rows[i3].split(",");
                            if (((Enumeration)enumerations.get(1)).getValues().size() == values.length) {
                                int j = 0;
                                while (j < values.length) {
                                    expr.addExpression(new NormalExpression(values[j]), ((Enumeration)enumerations.get(0)).getValues().get(i3), ((Enumeration)enumerations.get(1)).getValues().get(j));
                                    ++j;
                                }
                                ++i3;
                                continue;
                            }
                            break block23;
                        }
                        return expr;
                    }
                }
            }
        }
        expr = new EnumerationExpression(enumerations);
        var = this;
        while (var != null) {
            ArrayDeque<WorkExpression> workqueue = new ArrayDeque<WorkExpression>();
            workqueue.add(new WorkExpression(var.getIndices(), var.getExpressionString()));
            int i = 0;
            while (i < var.getIndices().length) {
                int limit = workqueue.size();
                int j = 0;
                while (j < limit) {
                    WorkExpression current = (WorkExpression)workqueue.pollFirst();
                    Subscript potential = this.getMdl().getSubscript(current.indices[i]);
                    if (potential != null) {
                        for (String value : potential.getValues()) {
                            String[] newindices = Arrays.copyOf(current.indices, current.indices.length);
                            newindices[i] = value;
                            String newexpression = current.expression;
                            newexpression = MdlUtil.replaceSubscripts(newexpression, potential.getName(), value);
                            workqueue.addLast(new WorkExpression(newindices, newexpression));
                        }
                    } else {
                        workqueue.addLast(current);
                    }
                    ++j;
                }
                ++i;
            }
            for (WorkExpression we : workqueue) {
                String expression = MdlUtil.finalize(we.expression, this.getMdl());
                if (this.next == null) {
                    expression = SubscriptVariable.removeComparisons(expression, this.indices, we.indices);
                }
                expr.addExpression(SubscriptVariable.parseExpression(expression), we.indices);
            }
            var = var.getNext();
        }
        return expr;
    }

    private static String removeComparisons(String expression, String[] subscripts, String[] values) {
        if (!expression.contains("=")) {
            return expression;
        }
        int i = 0;
        while (i < subscripts.length) {
            int j = 0;
            while (j < subscripts.length) {
                StringBuilder result = new StringBuilder();
                int offset = 0;
                Matcher matcher = Pattern.compile(subscripts[i] + "\\s*=\\s*" + subscripts[j]).matcher(expression);
                while (matcher.find()) {
                    result.append(expression.substring(offset, matcher.start()));
                    if (values[i].equals(values[j])) {
                        result.append("true");
                    } else {
                        result.append("false");
                    }
                    offset = matcher.end();
                }
                if (offset < expression.length()) {
                    result.append(expression.substring(offset));
                }
                expression = result.toString();
                ++j;
            }
            ++i;
        }
        return expression;
    }

    private class WorkExpression {
        String[] indices;
        String expression;

        private WorkExpression(String[] indices, String expression) {
            this.indices = indices;
            this.expression = expression;
        }
    }
}

