/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.manager;

import java.io.File;
import java.util.ArrayList;
import java.util.UUID;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.request.WriteResultRequest;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.db.request.WriteResult;
import org.simantics.layer0.Layer0;
import org.simantics.layer0.utils.direct.GraphUtils;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.manager.MemoryResult;
import org.simantics.sysdyn.manager.OldSysdynExperiment;

public class SaveResultSetJob
extends Job {
    private final ArrayList<MemoryResult> sysdynResults;
    private final OldSysdynExperiment experiment;
    private final Session session;
    private IProgressMonitor monitor;
    private File file;

    public SaveResultSetJob(OldSysdynExperiment experiment, Session session, ArrayList<MemoryResult> results) {
        super("Save Results");
        this.experiment = experiment;
        this.sysdynResults = results;
        this.session = session;
    }

    protected IStatus run(IProgressMonitor monitor) {
        this.monitor = monitor;
        if (this.sysdynResults == null || this.sysdynResults.size() == 0) {
            return Status.CANCEL_STATUS;
        }
        int resultItemsNumber = this.sysdynResults.get(0).numberOfVariables() * this.sysdynResults.size();
        monitor.beginTask("Save results", resultItemsNumber * 2 + 2);
        try {
            final Resource resultSetResource = (Resource)this.session.syncRequest((WriteResult)new WriteResultRequest<Resource>(){

                public Resource perform(WriteGraph graph) throws DatabaseException {
                    Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
                    Resource model = graph.getSingleObject(SaveResultSetJob.this.experiment.getResource(), l0.PartOf);
                    String name = NameUtils.findFreshName((ReadGraph)graph, (String)"ResultSet", (Resource)model, (Resource)l0.ConsistsOf, (String)"%s%d");
                    SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
                    Resource res = GraphUtils.create2((WriteGraph)graph, (Resource)sr.ResultSet, (Object[])new Object[]{l0.HasLabel, name, l0.HasName, name, l0.PartOf, model, sr.Result_time, System.currentTimeMillis()});
                    graph.claim(SaveResultSetJob.this.experiment.getResource(), sr.Experiment_resultSet, res);
                    return res;
                }
            });
            monitor.worked(1);
            int i = 0;
            while (i < this.sysdynResults.size()) {
                MemoryResult result = this.sysdynResults.get(i);
                final String name = new Integer(i + 1).toString();
                this.file = (File)this.session.syncRequest((Read)new Read<File>(){

                    public File perform(ReadGraph graph) throws DatabaseException {
                        File projectRoot;
                        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
                        Resource model = graph.getSingleObject(SaveResultSetJob.this.experiment.getResource(), l0.PartOf);
                        Resource project = graph.getSingleObject(model, l0.PartOf);
                        String projectName = (String)graph.getPossibleRelatedValue(project, l0.HasName);
                        File root = new File(Platform.getLocation().toOSString(), "www.simantics.org");
                        if (!root.isDirectory()) {
                            root.mkdir();
                        }
                        if (!(projectRoot = new File(root, projectName)).isDirectory()) {
                            projectRoot.mkdir();
                        }
                        File file = new File(projectRoot, UUID.randomUUID().toString() + ".dbb");
                        return file;
                    }
                });
                Thread saveThread = this.experiment.getSaveThread(result, this.file, this.monitor);
                saveThread.run();
                this.session.syncRequest((Write)new WriteRequest(){

                    public void perform(WriteGraph graph) throws DatabaseException {
                        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
                        String resultSetName = (String)graph.getRelatedValue(resultSetResource, l0.HasName);
                        SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
                        Resource res = GraphUtils.create2((WriteGraph)graph, (Resource)sr.Result, (Object[])new Object[]{l0.HasLabel, name, l0.HasName, resultSetName + "#" + name, sr.Result_resultFile, SaveResultSetJob.this.file.getAbsolutePath(), sr.Result_time, System.currentTimeMillis()});
                        graph.claim(resultSetResource, sr.Experiment_result, res);
                    }
                });
                ++i;
            }
        }
        catch (DatabaseException e1) {
            e1.printStackTrace();
        }
        monitor.done();
        return Status.OK_STATUS;
    }

    public boolean belongsTo(Object family) {
        return "SaveResultSetJob".equals(family);
    }

    protected void canceling() {
    }
}

