/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.manager;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.modelica.data.DataSet;
import org.simantics.modelica.data.SimulationResult;
import org.simantics.simulation.ontology.SimulationResource;
import org.simantics.spreadsheet.common.matrix.VariantMatrix;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.manager.MemoryResult;
import org.simantics.sysdyn.manager.SysdynDataSet;
import org.simantics.sysdyn.manager.SysdynModel;
import org.simantics.sysdyn.manager.SysdynModelManager;
import org.simantics.sysdyn.representation.Configuration;
import org.simantics.sysdyn.representation.IElement;
import org.simantics.sysdyn.representation.Module;
import org.simantics.sysdyn.representation.Variable;
import org.simantics.sysdyn.representation.utils.IndexUtils;
import org.simantics.utils.datastructures.Pair;

public class HistoryDatasetResult
extends SimulationResult {
    private boolean disposed;

    public void read(File file, int interval) {
    }

    public void read(InputStream stream, int interval) {
    }

    public void disposeListeners() {
        this.disposed = true;
    }

    public void read(final MemoryResult sysdynResult, final Resource historyData) {
        Simantics.getSession().asyncRequest((Read)new Read<Pair<SysdynModel, List<DataSet>>>(){

            public Pair<SysdynModel, List<DataSet>> perform(ReadGraph graph) throws DatabaseException {
                String name;
                Variant cell;
                int y;
                ArrayList<SysdynDataSet> variables = new ArrayList<SysdynDataSet>();
                SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
                Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
                SimulationResource simu = SimulationResource.getInstance((ReadGraph)graph);
                String datasetName = "History Dataset";
                VariantMatrix vm = null;
                SysdynModel sdmodel = null;
                String timeVariable = "time";
                boolean columns = true;
                try {
                    org.simantics.db.layer0.variable.Variable v;
                    org.simantics.db.layer0.variable.Variable range;
                    Pair emptyResult = new Pair(sdmodel, variables);
                    Resource model = graph.getPossibleObject(historyData, l0.PartOf);
                    Resource config = graph.getPossibleObject(model, simu.HasConfiguration);
                    sdmodel = SysdynModelManager.getInstance(graph.getSession()).getModel(graph, config);
                    sdmodel.update(graph);
                    datasetName = NameUtils.getSafeLabel((ReadGraph)graph, (Resource)historyData);
                    Resource sheet = graph.getPossibleObject(historyData, sr.HistoryDataset_sheet);
                    if (sheet == null) {
                        return emptyResult;
                    }
                    String start = (String)graph.getPossibleRelatedValue(historyData, sr.HistoryDataset_start);
                    String end = (String)graph.getPossibleRelatedValue(historyData, sr.HistoryDataset_end);
                    if (start == null || start.isEmpty() || end == null || end.isEmpty()) {
                        return emptyResult;
                    }
                    String r = start + ":" + end;
                    String time = (String)graph.getPossibleRelatedValue(historyData, sr.HistoryDataset_timeName);
                    if (time != null && !time.isEmpty()) {
                        timeVariable = time;
                    }
                    if (graph.hasStatement(historyData, sr.HistoryDataset_columns)) {
                        columns = (Boolean)graph.getRelatedValue(historyData, sr.HistoryDataset_columns, (Binding)Bindings.BOOLEAN);
                    }
                    if ((range = (v = (org.simantics.db.layer0.variable.Variable)graph.adapt(sheet, org.simantics.db.layer0.variable.Variable.class)).getChild(graph, r)) == null) {
                        return emptyResult;
                    }
                    Variant content = (Variant)range.getPropertyValue(graph, "content", (Binding)Bindings.VARIANT);
                    Object matrixValue = content.getValue();
                    if (matrixValue instanceof VariantMatrix) {
                        vm = (VariantMatrix)matrixValue;
                    }
                }
                catch (DatabaseException e) {
                    return new Pair(sdmodel, variables);
                }
                catch (NegativeArraySizeException e) {
                    return new Pair(sdmodel, variables);
                }
                int x = columns ? vm.getColumnCount() : vm.getRowCount();
                int n = y = columns ? vm.getRowCount() : vm.getColumnCount();
                if (vm == null || x < 2 || y < 2) {
                    return new Pair((Object)sdmodel, variables);
                }
                String[] names = new String[x];
                HashMap values = new HashMap();
                Integer timeIndex = null;
                int i = 0;
                while (i < x) {
                    Variant variant = cell = columns ? vm.get(0, i) : vm.get(i, 0);
                    if (cell != null && cell.getValue() != null) {
                        name = cell.getValue().toString();
                        if (!values.containsKey(name)) {
                            names[i] = name;
                            values.put(names[i], new ArrayList());
                            if (names[i].equals(timeVariable)) {
                                timeIndex = i;
                            }
                        }
                    } else {
                        names[i] = null;
                    }
                    ++i;
                }
                if (timeIndex == null || names[timeIndex] == null) {
                    return new Pair((Object)sdmodel, variables);
                }
                i = 1;
                while (i < y) {
                    cell = columns ? vm.get(i, timeIndex.intValue()) : vm.get(timeIndex.intValue(), i);
                    Double value = null;
                    if (cell != null) {
                        value = HistoryDatasetResult.this.getDoubleValue(cell);
                    }
                    ((ArrayList)values.get(names[timeIndex])).add(new Pair((Object)value, (Object)value));
                    ++i;
                }
                i = 0;
                while (i < x) {
                    if (i != timeIndex && names[i] != null) {
                        Variable variable;
                        int j = 1;
                        while (j < y) {
                            Pair time;
                            Double value;
                            Variant cell2;
                            Variant variant = cell2 = columns ? vm.get(j, i) : vm.get(i, j);
                            if (cell2 != null && cell2.getValue() != null && (value = HistoryDatasetResult.this.getDoubleValue(cell2)) != null && (time = (Pair)((ArrayList)values.get(names[timeIndex])).get(j - 1)) != null && time.first != null) {
                                ((ArrayList)values.get(names[i])).add(new Pair((Object)((Double)time.first), (Object)value));
                            }
                            ++j;
                        }
                        ArrayList doubles = (ArrayList)values.get(names[i]);
                        name = names[i];
                        if (name.contains("[") && (variable = HistoryDatasetResult.this.getVariable(name, sdmodel.getConfiguration())) != null) {
                            name = IndexUtils.equationRangesToIndexes(variable, name);
                        }
                        name = name.replace(" ", "_");
                        SysdynDataSet ds = new SysdynDataSet(name, datasetName, new double[doubles.size()], new double[doubles.size()]);
                        variables.add(ds);
                        int d = 0;
                        while (d < doubles.size()) {
                            Pair pair = (Pair)doubles.get(d);
                            ds.times[d] = (Double)pair.first;
                            ds.values[d] = (Double)pair.second;
                            ++d;
                        }
                    }
                    ++i;
                }
                return new Pair((Object)sdmodel, variables);
            }
        }, (Listener)new Listener<Pair<SysdynModel, List<DataSet>>>(){

            public void execute(Pair<SysdynModel, List<DataSet>> result) {
                HistoryDatasetResult.this.variables = (List)result.second;
                sysdynResult.setResult(HistoryDatasetResult.this);
                if (result.first != null) {
                    ((SysdynModel)result.first).resultChanged();
                }
            }

            public void exception(Throwable t) {
                t.printStackTrace();
            }

            public boolean isDisposed() {
                return HistoryDatasetResult.this.disposed;
            }
        });
    }

    private Variable getVariable(String path, Configuration configuration) {
        String next = path;
        int index = next.indexOf(".");
        if (index > 0) {
            path = path.substring(index + 1);
            next = next.substring(0, index);
        } else if (next.contains("[")) {
            next = next.substring(0, next.indexOf("["));
        }
        for (IElement e : configuration.getElements()) {
            if (e instanceof Variable) {
                Variable v = (Variable)e;
                if (!v.getName().equals(next)) continue;
                return v;
            }
            if (!(e instanceof Module) || !((Module)e).getName().equals(next)) continue;
            return this.getVariable(path, ((Module)e).getType().getConfiguration());
        }
        return null;
    }

    private Double getDoubleValue(Variant cell) {
        if (cell.getValue() == null) {
            return null;
        }
        Double value = null;
        try {
            value = Double.parseDouble(cell.getValue().toString());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return value;
    }

    public DataSet getDataSet(String name) {
        DataSet ds = super.getDataSet(name);
        if (ds == null && name.contains(".")) {
            ds = super.getDataSet(name.substring(name.lastIndexOf(".") + 1));
        }
        return ds;
    }
}

