/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.adapter;

import java.util.Arrays;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.Datatypes;
import org.simantics.databoard.adapter.AdaptException;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.type.Datatype;
import org.simantics.db.ReadGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.sysdyn.adapter.ValueIndexVariableBase;
import org.simantics.sysdyn.nodemanager.SysdynValueData;

public class ValueIndexVariableI
extends ValueIndexVariableBase<Double> {
    final Variable parent;
    final int index;
    final boolean scalar;

    public ValueIndexVariableI(Variable parent, SysdynValueData data, int index, boolean scalar) throws DatabaseException {
        super("");
        this.parent = parent;
        this.data = data;
        this.index = index;
        this.scalar = scalar;
    }

    private Double getValueScalar() {
        double[] array = this.data.values;
        if (array == null || this.index < 0 || array.length < this.index + 1) {
            return Double.NaN;
        }
        return array[this.index];
    }

    @Override
    public <U> U getValue(ReadGraph graph) throws DatabaseException {
        if (this.scalar) {
            return (U)this.getValueScalar();
        }
        return (U)new double[]{this.getValueScalar()};
    }

    @Override
    public <U> U getValue(ReadGraph graph, Binding binding) throws DatabaseException {
        try {
            Binding b = Bindings.getBinding((Datatype)this.getDatatype(graph));
            return (U)Bindings.adapt(this.getValue(graph), (Binding)b, (Binding)binding);
        }
        catch (AdaptException e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    @Override
    public void setValue(WriteGraph graph, Object value) throws DatabaseException {
        double[] existing = this.data.values;
        double[] newValue = Arrays.copyOf(existing, existing.length);
        newValue[this.index] = (Double)value;
        super.setValue(graph, newValue);
    }

    @Override
    public void setValue(WriteGraph graph, Object value, Binding binding) throws DatabaseException {
        this.setValue(graph, value);
    }

    @Override
    public String getName(ReadGraph graph) throws DatabaseException {
        return "$" + this.index;
    }

    @Override
    public Datatype getDatatype(ReadGraph graph) throws DatabaseException {
        if (this.scalar) {
            return Datatypes.DOUBLE;
        }
        return Datatypes.DOUBLE_ARRAY;
    }

    @Override
    public Double getValue() {
        throw new IllegalStateException();
    }
}

