/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.xmile;

import java.io.File;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.handlers.HandlerUtil;
import org.simantics.Simantics;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Write;
import org.simantics.sysdyn.modelImport.model.Model;
import org.simantics.sysdyn.xmile.XmileParser;
import org.simantics.utils.ui.ExceptionUtils;

public class ImportHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        FileDialog dialog = new FileDialog(HandlerUtil.getActiveShell((ExecutionEvent)event), 4096);
        dialog.setFilterExtensions(new String[]{"*.xmile", "*.*"});
        String fileName = dialog.open();
        if (fileName == null) {
            return null;
        }
        try {
            final Model model = new XmileParser().parse(new File(fileName));
            Simantics.getSession().syncRequest((Write)new WriteRequest(){

                public void perform(WriteGraph graph) throws DatabaseException {
                    model.write(graph, (Resource)Simantics.getProject().get());
                }
            });
        }
        catch (Exception e) {
            ExceptionUtils.logAndShowError((String)("XMILE import failed: " + e.getMessage()), (Throwable)e);
        }
        return null;
    }
}

