/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.xmile;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.Marshaller;
import java.io.File;
import java.io.OutputStream;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.handlers.HandlerUtil;
import org.simantics.Simantics;
import org.simantics.db.Resource;
import org.simantics.db.request.Read;
import org.simantics.sysdyn.xmile.ModelTransform;
import org.simantics.sysdyn.xmile.schema.Xmile;
import org.simantics.utils.ui.AdaptionUtils;
import org.simantics.utils.ui.ExceptionUtils;

public class ExportHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        FileDialog dialog = new FileDialog(HandlerUtil.getActiveShell((ExecutionEvent)event), 8192);
        dialog.setFilterExtensions(new String[]{"*.xmile", "*.*"});
        dialog.setOverwrite(true);
        String fileName = dialog.open();
        if (fileName == null) {
            return null;
        }
        try {
            ModelTransform request;
            ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
            Resource model = (Resource)AdaptionUtils.adaptToSingle((Object)selection, Resource.class);
            String includeView = event.getParameter("org.simantics.sysdyn.xmile.export.includeView");
            if (includeView != null) {
                if (!includeView.equals("true") && !includeView.equals("false")) {
                    throw new ExecutionException("incorrect value for includeView");
                }
                request = new ModelTransform(model, includeView.equals("true"));
            } else {
                request = new ModelTransform(model);
            }
            Xmile xmile = (Xmile)Simantics.getSession().syncRequest((Read)request);
            JAXBContext context = JAXBContext.newInstance((String)"org.simantics.sysdyn.xmile.schema");
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.marshal((Object)xmile, (OutputStream)System.out);
            marshaller.marshal((Object)xmile, new File(fileName));
        }
        catch (Exception e) {
            ExceptionUtils.logAndShowError((String)("XMILE export failed: " + e.getMessage()), (Throwable)e);
        }
        return null;
    }
}

