/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.trend;

import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import org.jfree.chart.plot.DefaultDrawingSupplier;
import org.jfree.chart.plot.DrawingSupplier;
import org.jfree.chart.renderer.AbstractRenderer;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.StackedBarRenderer;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.Dataset;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.utils.ListUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.exception.MissingVariableException;
import org.simantics.db.layer0.request.PossibleActiveExperiment;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.jfreechart.chart.AbstractDataset;
import org.simantics.jfreechart.chart.IRenderer;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.operation.Layer0X;
import org.simantics.sysdyn.Functions;
import org.simantics.sysdyn.JFreeChartResource;
import org.simantics.sysdyn.adapter.VariableRVIUtils;
import org.simantics.sysdyn.manager.SysdynDataSet;

public class CategoryDataset
extends AbstractDataset
implements org.simantics.jfreechart.chart.CategoryDataset {
    private List<Resource> seriesList;
    private String realizationURI;
    private IRenderer renderer;
    private DefaultCategoryDataset dataset;
    private DatasetListener listener;

    public CategoryDataset(ReadGraph graph, Resource resource) throws DatabaseException {
        super(resource);
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        ModelingResources mr = ModelingResources.getInstance((ReadGraph)graph);
        JFreeChartResource jfree = JFreeChartResource.getInstance((ReadGraph)graph);
        Resource model = resource;
        while ((model = graph.getPossibleObject(model, l0.PartOf)) != null && !graph.isInstanceOf(model, mr.StructuralModel)) {
        }
        this.realizationURI = null;
        Resource realization = (Resource)graph.syncRequest((Read)new PossibleActiveExperiment(model));
        if (realization == null) {
            Layer0X L0X = Layer0X.getInstance((ReadGraph)graph);
            realization = graph.getPossibleObject(model, L0X.HasBaseRealization);
        }
        if (realization != null) {
            this.realizationURI = graph.getURI(realization);
        }
        if (this.realizationURI == null) {
            return;
        }
        Resource seriesList = graph.getPossibleObject(resource, jfree.Dataset_seriesList);
        if (seriesList != null) {
            this.seriesList = ListUtils.toList((ReadGraph)graph, (Resource)seriesList);
        }
        Resource rendererResource = graph.getPossibleObject(resource, jfree.Dataset_renderer);
        this.renderer = (IRenderer)graph.adapt(rendererResource, IRenderer.class);
    }

    public Dataset getDataset() {
        if (this.seriesList == null || this.seriesList.isEmpty() || Simantics.getSession() == null) {
            return null;
        }
        if (this.dataset == null) {
            this.dataset = new DefaultCategoryDataset();
        }
        if (this.listener == null || this.listener.isDisposed()) {
            this.listener = new DatasetListener();
            Simantics.getSession().asyncRequest((Read)new Read<ArrayList<TempSeries>>(){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public ArrayList<TempSeries> perform(ReadGraph graph) throws DatabaseException {
                    JFreeChartResource jfree = JFreeChartResource.getInstance((ReadGraph)graph);
                    ArrayList<TempSeries> series = new ArrayList<TempSeries>();
                    if (CategoryDataset.this.seriesList != null) {
                        for (Resource r : CategoryDataset.this.seriesList) {
                            String rvi = (String)graph.getPossibleRelatedValue(r, jfree.variableRVI);
                            if (rvi == null) continue;
                            try {
                                ArrayList result2;
                                Variable v = Variables.getVariable((ReadGraph)graph, (String)(CategoryDataset.this.realizationURI + rvi));
                                Variable dsVariable = v.browsePossible(graph, "#" + Functions.ACTIVE_DATASETS);
                                if (dsVariable == null) {
                                    return series;
                                }
                                Object object = dsVariable.getValue(graph);
                                if (object == null || !(object instanceof ArrayList)) {
                                    return series;
                                }
                                ArrayList datasets = new ArrayList();
                                for (Object o : (ArrayList)object) {
                                    if (!(o instanceof SysdynDataSet)) continue;
                                    datasets.add((SysdynDataSet)o);
                                }
                                String[] filter = (String[])graph.getPossibleRelatedValue(r, jfree.variableFilter);
                                if (filter != null && (result2 = VariableRVIUtils.getDataset(datasets, (String[])filter)) != null) {
                                    datasets = result2;
                                }
                                Double chartTime = null;
                                if (!datasets.isEmpty()) {
                                    Resource chart;
                                    Resource plot;
                                    Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
                                    Resource datasetResource = graph.getPossibleObject(r, l0.PartOf);
                                    if (datasetResource != null && (plot = graph.getPossibleObject(datasetResource, l0.PartOf)) != null && (chart = graph.getPossibleObject(plot, l0.PartOf)) != null) {
                                        chartTime = (Double)graph.getPossibleRelatedValue(chart, jfree.Chart_time);
                                    }
                                }
                                for (SysdynDataSet dataset : datasets) {
                                    Object name;
                                    double[] va = dataset.values;
                                    if (va == null || va.length == 0) continue;
                                    Double time = (Double)graph.getPossibleRelatedValue(r, jfree.Series_time, (Binding)Bindings.DOUBLE);
                                    if (time == null) {
                                        time = chartTime;
                                    }
                                    if (time == null) {
                                        Variable run = Variables.getVariable((ReadGraph)graph, (String)CategoryDataset.this.realizationURI);
                                        if (run == null) {
                                            return null;
                                        }
                                        Variable timeVar = run.browsePossible(graph, "#" + Functions.TIME);
                                        if (timeVar != null) {
                                            time = (Double)timeVar.getValue(graph, (Binding)Bindings.DOUBLE);
                                        }
                                    }
                                    Double value = null;
                                    if (time == null) {
                                        value = va[va.length - 1];
                                    } else {
                                        double[] ta = dataset.times;
                                        int i = 0;
                                        while (i < ta.length) {
                                            double t = ta[i];
                                            if (time <= t) {
                                                value = va[i];
                                                break;
                                            }
                                            ++i;
                                        }
                                        if (value == null) {
                                            value = va[va.length - 1];
                                        }
                                    }
                                    String label = (String)graph.getPossibleRelatedValue(r, Layer0.getInstance((ReadGraph)graph).HasLabel);
                                    Object object2 = name = label == null || label.isEmpty() ? dataset.name : label;
                                    if (dataset.resultIndex != null) {
                                        name = (String)name + "(" + String.valueOf(dataset.resultIndex) + ")";
                                    }
                                    series.add(new TempSeries((String)name, dataset.result, value));
                                }
                            }
                            catch (MissingVariableException missingVariableException) {
                                // empty catch block
                            }
                        }
                    }
                    return series;
                }
            }, (Listener)this.listener);
        }
        return this.dataset;
    }

    public AbstractRenderer getRenderer() {
        return this.renderer.getRenderer();
    }

    public void dispose() {
        super.dispose();
        if (this.listener != null) {
            this.listener.dispose();
            this.listener = null;
        }
    }

    private class DatasetListener
    implements Listener<ArrayList<TempSeries>> {
        private boolean disposed = false;

        private DatasetListener() {
        }

        public void dispose() {
            this.disposed = true;
        }

        public void execute(final ArrayList<TempSeries> series) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ((DatasetListener)DatasetListener.this).CategoryDataset.this.dataset.clear();
                    BarRenderer renderer = (BarRenderer)CategoryDataset.this.getRenderer();
                    renderer.getPlot().setDrawingSupplier((DrawingSupplier)new DefaultDrawingSupplier());
                    int i = 0;
                    while (i < series.size()) {
                        TempSeries s = (TempSeries)series.get(i);
                        if (renderer instanceof StackedBarRenderer && s.name.contains("[")) {
                            Object category = s.name.substring(0, s.name.indexOf(91));
                            if (s.result != null) {
                                category = (String)category + " : " + s.result;
                            }
                            String series2 = s.name.substring(s.name.indexOf(91));
                            ((DatasetListener)DatasetListener.this).CategoryDataset.this.dataset.addValue((Number)s.value, (Comparable)((Object)series2), (Comparable)category);
                        } else {
                            ((DatasetListener)DatasetListener.this).CategoryDataset.this.dataset.addValue((Number)s.value, (Comparable)((Object)(s.result == null ? "Current" : s.result)), (Comparable)((Object)s.name));
                        }
                        ++i;
                    }
                }
            });
        }

        public void exception(Throwable t) {
            t.printStackTrace();
        }

        public boolean isDisposed() {
            return this.disposed;
        }
    }

    private class TempSeries {
        public String name;
        public String result;
        public Double value;

        public TempSeries(String name, String result, Double value) {
            this.name = name;
            this.value = value;
            this.result = result;
        }

        public String toString() {
            return "TempSeries: " + this.name + ", " + String.valueOf(this.value) + ", " + this.result;
        }
    }
}

