/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.properties.widgets.arrays;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.common.modifiers.EnumeratedValue;
import org.simantics.browsing.ui.common.modifiers.Enumeration;
import org.simantics.browsing.ui.content.Labeler;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Write;
import org.simantics.utils.ObjectUtils;

public abstract class ComboBoxModifier<T>
implements Labeler.CustomModifier {
    private final Enumeration<T> enumeration;
    private final EnumeratedValue<T> value;
    private final List<String> values;
    private final Session session;
    private Combo combo;
    int select;

    public ComboBoxModifier(Session session, Enumeration<T> enumeration, T value) {
        this(session, enumeration, enumeration.find(value));
    }

    public ComboBoxModifier(Session session, Enumeration<T> enumeration, EnumeratedValue<T> value) {
        if (session == null) {
            throw new NullPointerException("null session");
        }
        if (enumeration == null) {
            throw new NullPointerException("null enumeration");
        }
        if (enumeration.size() == 0) {
            throw new IllegalArgumentException("");
        }
        this.enumeration = enumeration;
        this.value = value;
        this.session = session;
        this.select = 0;
        boolean found = false;
        this.values = new ArrayList<String>();
        for (EnumeratedValue v : enumeration.values()) {
            this.values.add(v.getName());
            if (v == value) {
                found = true;
            }
            if (found) continue;
            ++this.select;
        }
    }

    public Object createControl(Object parentControl, Object controlItem, int columnIndex, NodeContext context) {
        this.combo = new Combo((Composite)parentControl, 2060);
        for (String item : this.values) {
            this.combo.add(item);
        }
        this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String index = ((Combo)e.getSource()).getText();
                ComboBoxModifier.this.modify(index);
            }
        });
        this.combo.select(this.select);
        return this.combo;
    }

    public String getValue() {
        return ((EnumeratedValue)this.enumeration.values().get(0)).getName();
    }

    public final String isValid(String label) {
        if (this.enumeration.findByName(label) == null) {
            return "Value '" + label + "' is not among the enumerated values " + String.valueOf(this.enumeration.values());
        }
        return null;
    }

    public void modify(String label) {
        Object newObject;
        int index = this.values.indexOf(label);
        if (index == -1) {
            throw new IllegalArgumentException("Cannot modify enumeration with value '" + label + "', not among the enumerated values " + String.valueOf(this.values));
        }
        EnumeratedValue<T> oldEnumValue = this.value;
        EnumeratedValue newEnumValue = (EnumeratedValue)this.enumeration.values().get(index);
        final Object oldObject = oldEnumValue != null ? oldEnumValue.getObject() : null;
        Object object = newObject = newEnumValue != null ? newEnumValue.getObject() : null;
        if (ObjectUtils.objectEquals((Object)oldObject, (Object)newObject)) {
            return;
        }
        try {
            this.session.getSession().syncRequest((Write)new WriteRequest(){

                public void perform(WriteGraph graph) throws DatabaseException {
                    ComboBoxModifier.this.modifyWithObject(graph, oldObject, newObject);
                }
            });
        }
        catch (DatabaseException e) {
            this.handleException(e);
        }
        this.combo.dispose();
    }

    protected abstract void modifyWithObject(WriteGraph var1, T var2, T var3) throws DatabaseException;

    protected void handleException(DatabaseException e) {
        throw new RuntimeException(e);
    }
}

