/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.properties.widgets;

import java.net.URL;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.simantics.Simantics;
import org.simantics.browsing.ui.swt.widgets.impl.Widget;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.db.AsyncReadGraph;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.PossibleModel;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.procedure.AsyncListener;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.sysdyn.ui.Activator;
import org.simantics.sysdyn.ui.validation.ValidationUtils;
import org.simantics.sysdyn.utils.Function;
import org.simantics.utils.ui.ISelectionUtils;

public class ShortcutTabWidget
implements Widget {
    TabFolder tabFolder;
    TabItem variables;
    TabItem functions;
    Table variableTable;
    Table functionTable;
    Composite composite;
    TableItem item2;
    CopyOnWriteArrayList<Runnable> dependencyListeners = new CopyOnWriteArrayList();
    private final LocalResourceManager resourceManager;

    public ShortcutTabWidget(Composite parent, WidgetSupport support, int style) {
        if (support != null) {
            support.register((Widget)this);
        }
        this.composite = new Composite(parent, style);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(this.composite);
        this.tabFolder = new TabFolder(this.composite, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.tabFolder);
        GridLayoutFactory.fillDefaults().applyTo((Composite)this.tabFolder);
        this.variables = new TabItem(this.tabFolder, 0);
        this.variables.setText("Variables");
        this.variableTable = new Table((Composite)this.tabFolder, 624644);
        this.variables.setControl((Control)this.variableTable);
        this.functions = new TabItem(this.tabFolder, 0);
        this.functions.setText("Functions");
        this.functionTable = new Table((Composite)this.tabFolder, 624644);
        this.resourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)this.functionTable);
        this.functions.setControl((Control)this.functionTable);
    }

    public Composite getWidget() {
        return this.composite;
    }

    private void addFunctions(Resource model) {
        ArrayList functionList = Function.getUserDefinedFunctions((Resource)model);
        functionList.addAll(Function.getSharedFunctions((Resource)model));
        functionList.addAll(Function.getAllBuiltInFunctions());
        Collections.sort(functionList);
        for (Function function : functionList) {
            TableItem item = new TableItem(this.functionTable, 0);
            item.setText(function.getName() + "()");
            String parameterList = Function.inputListToString((ArrayList)function.getInputList());
            item.setData((Object)(function.getName() + "(" + parameterList + ")"));
            item.setImage(ShortcutTabWidget.getImage(this.resourceManager, function));
        }
    }

    public void setInput(ISessionContext context, Object input) {
        Resource variable;
        if (input instanceof IStructuredSelection && (variable = (Resource)ISelectionUtils.filterSingleSelection((Object)input, Resource.class)) != null) {
            try {
                Resource model = (Resource)Simantics.getSession().syncRequest((Read)new Read<Resource>(){

                    public Resource perform(ReadGraph graph) throws DatabaseException {
                        return (Resource)graph.syncRequest((Read)new PossibleModel(variable));
                    }
                });
                this.addFunctions(model);
            }
            catch (DatabaseException e) {
                e.printStackTrace();
            }
            Simantics.getSession().asyncRequest((Read)new Read<HashSet<String>>(){

                public HashSet<String> perform(ReadGraph graph) throws DatabaseException {
                    return ValidationUtils.getDependencies(graph, variable);
                }
            }, (AsyncListener)new AsyncListener<HashSet<String>>(){

                public void execute(AsyncReadGraph graph, HashSet<String> result) {
                    final HashSet<String> dependencies = result;
                    ShortcutTabWidget.this.variableTable.getDisplay().asyncExec(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            TableItem item;
                            if ((this).ShortcutTabWidget.this.variableTable.isDisposed()) {
                                return;
                            }
                            TableItem[] items = (this).ShortcutTabWidget.this.variableTable.getItems();
                            ArrayList<String> itemStrings = new ArrayList<String>();
                            TableItem[] tableItemArray = items;
                            int n = items.length;
                            int n2 = 0;
                            while (n2 < n) {
                                TableItem i = tableItemArray[n2];
                                String text = i.getText();
                                if (dependencies.contains(text)) {
                                    itemStrings.add(text);
                                } else {
                                    (this).ShortcutTabWidget.this.variableTable.remove((this).ShortcutTabWidget.this.variableTable.indexOf(i));
                                }
                                ++n2;
                            }
                            for (String d : dependencies) {
                                if (itemStrings.contains(d)) continue;
                                item = new TableItem((this).ShortcutTabWidget.this.variableTable, 0);
                                item.setText(d);
                                item.setData((Object)d);
                            }
                            this.sort();
                            String selfName = this.getName();
                            if (selfName != null) {
                                item = new TableItem((this).ShortcutTabWidget.this.variableTable, 0);
                                item.setText(selfName);
                                item.setData((Object)selfName);
                                item = new TableItem((this).ShortcutTabWidget.this.variableTable, 0);
                                item.setText("time");
                                item.setData((Object)"time");
                                item = new TableItem((this).ShortcutTabWidget.this.variableTable, 0);
                                item.setText("startTime");
                                item.setData((Object)"startTime");
                                item = new TableItem((this).ShortcutTabWidget.this.variableTable, 0);
                                item.setText("stopTime");
                                item.setData((Object)"stopTime");
                                item = new TableItem((this).ShortcutTabWidget.this.variableTable, 0);
                                item.setText("timeStep");
                                item.setData((Object)"timeStep");
                            }
                            CopyOnWriteArrayList<Runnable> copyOnWriteArrayList = (this).ShortcutTabWidget.this.dependencyListeners;
                            synchronized (copyOnWriteArrayList) {
                                for (Runnable listener : (this).ShortcutTabWidget.this.dependencyListeners) {
                                    listener.run();
                                }
                            }
                        }
                    });
                }

                private void sort() {
                    TableItem[] connectedVariables = ShortcutTabWidget.this.variableTable.getItems();
                    Collator collator = Collator.getInstance(Locale.getDefault());
                    int i = 1;
                    while (i < connectedVariables.length) {
                        String value1 = connectedVariables[i].getText(0);
                        int j = 0;
                        while (j < i) {
                            String value2 = connectedVariables[j].getText(0);
                            if (collator.compare(value1, value2) < 0) {
                                String value = connectedVariables[i].getText(0);
                                connectedVariables[i].dispose();
                                TableItem item2 = new TableItem(ShortcutTabWidget.this.variableTable, 0, j);
                                item2.setText(value);
                                item2.setData((Object)value);
                                connectedVariables = ShortcutTabWidget.this.variableTable.getItems();
                                break;
                            }
                            ++j;
                        }
                        ++i;
                    }
                }

                private String getName() {
                    String selfName = null;
                    try {
                        selfName = (String)Simantics.getSession().syncRequest((Read)new Read<String>(){

                            public String perform(ReadGraph graph) throws DatabaseException {
                                Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
                                Object selfName = graph.getPossibleRelatedValue(variable, l0.HasName);
                                if (selfName instanceof String) {
                                    return (String)selfName;
                                }
                                return null;
                            }
                        });
                    }
                    catch (DatabaseException e) {
                        e.printStackTrace();
                    }
                    return selfName;
                }

                public void exception(AsyncReadGraph graph, Throwable throwable) {
                    throwable.printStackTrace();
                }

                public boolean isDisposed() {
                    return ShortcutTabWidget.this.variableTable.isDisposed();
                }
            });
        }
    }

    public void addFocusListener(FocusListener listener) {
        this.functionTable.addFocusListener(listener);
        this.variableTable.addFocusListener(listener);
    }

    public void addMouseListener(MouseListener listener) {
        this.functionTable.addMouseListener(listener);
        this.variableTable.addMouseListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDependencyListener(Runnable listener) {
        CopyOnWriteArrayList<Runnable> copyOnWriteArrayList = this.dependencyListeners;
        synchronized (copyOnWriteArrayList) {
            this.dependencyListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDependencyListener(Runnable listener) {
        CopyOnWriteArrayList<Runnable> copyOnWriteArrayList = this.dependencyListeners;
        synchronized (copyOnWriteArrayList) {
            this.dependencyListeners.remove(listener);
        }
    }

    public Table getVariableTable() {
        return this.variableTable;
    }

    public static Image getImage(LocalResourceManager rm, Function function) {
        switch (function.getType()) {
            case USER_DEFINED: {
                return rm.createImage(ImageDescriptor.createFromURL((URL)Activator.getDefault().getBundle().getResource("icons/function.png")));
            }
            case SHARED: {
                return rm.createImage(ImageDescriptor.createFromURL((URL)Activator.getDefault().getBundle().getResource("icons/functionLink.png")));
            }
            case VENSIM: {
                return rm.createImage(ImageDescriptor.createFromURL((URL)Activator.getDefault().getBundle().getResource("icons/vensimFunction.png")));
            }
            case SYSDYN: {
                return rm.createImage(ImageDescriptor.createFromURL((URL)Activator.getDefault().getBundle().getResource("icons/sysdynFunction.png")));
            }
            case MODELICA: {
                return rm.createImage(ImageDescriptor.createFromURL((URL)Activator.getDefault().getBundle().getResource("icons/modelicaFunction.png")));
            }
            case MODELICA_ARRAY: {
                return rm.createImage(ImageDescriptor.createFromURL((URL)Activator.getDefault().getBundle().getResource("icons/modelicaArrayFunction.png")));
            }
        }
        return null;
    }
}

