/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.properties.widgets;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.simantics.browsing.ui.swt.widgets.Button;
import org.simantics.browsing.ui.swt.widgets.impl.SelectionListenerImpl;
import org.simantics.browsing.ui.swt.widgets.impl.Widget;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.utils.ui.ISelectionUtils;

public class DelayMarkWidget
implements Widget {
    List<Resource> variables = null;
    Button delayMarkButton;

    public DelayMarkWidget(Composite parent, WidgetSupport support, int style) {
        support.register((Widget)this);
        this.delayMarkButton = new Button(parent, support, style |= 0x20);
        this.delayMarkButton.setText("Delay mark");
    }

    public void setInput(ISessionContext context, Object input) {
        ISelection selection;
        if (input instanceof ISelection && (selection = (ISelection)input) instanceof IStructuredSelection) {
            List resources = ISelectionUtils.filterSelection((ISelection)selection, Resource.class);
            if (resources != null && !resources.isEmpty()) {
                this.variables = resources;
            } else {
                List resourceLists = ISelectionUtils.filterSelection((ISelection)selection, ArrayList.class);
                this.variables = (List)resourceLists.get(0);
            }
        }
        if (this.variables == null) {
            return;
        }
        try {
            context.getSession().syncRequest((Read)new ReadRequest(){

                public void run(ReadGraph graph) throws DatabaseException {
                    SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
                    boolean hasDelayMarks = false;
                    boolean hasNotDelayMarks = false;
                    for (Resource variable : DelayMarkWidget.this.variables) {
                        if (graph.hasStatement(variable, sr.DependencyConnection_delayMark)) {
                            hasDelayMarks = true;
                            continue;
                        }
                        hasNotDelayMarks = true;
                    }
                    final org.eclipse.swt.widgets.Button button = DelayMarkWidget.this.getWidget();
                    final boolean delayMark = hasDelayMarks;
                    final boolean mixedDelayMarks = hasDelayMarks && hasNotDelayMarks;
                    button.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (button.isDisposed()) {
                                return;
                            }
                            button.setSelection(delayMark);
                            button.setGrayed(mixedDelayMarks);
                        }
                    });
                }
            });
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
        this.delayMarkButton.addSelectionListener((SelectionListener)new SelectionListenerImpl<ArrayList<Resource>>(context){

            public void apply(WriteGraph graph, ArrayList<Resource> inputs) throws DatabaseException {
                if (inputs == null) {
                    return;
                }
                SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
                boolean nextState = true;
                for (Resource variable : DelayMarkWidget.this.variables) {
                    if (!graph.hasStatement(variable, sr.DependencyConnection_delayMark)) continue;
                    nextState = false;
                    break;
                }
                try {
                    if (nextState) {
                        for (Resource input : inputs) {
                            graph.claim(input, SysdynResource.getInstance((ReadGraph)graph).DependencyConnection_delayMark, null, input);
                        }
                    } else {
                        for (Resource input : inputs) {
                            graph.deny(input, sr.DependencyConnection_delayMark);
                        }
                    }
                }
                catch (DatabaseException e) {
                    e.printStackTrace();
                }
                final org.eclipse.swt.widgets.Button button = DelayMarkWidget.this.getWidget();
                button.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        button.setGrayed(false);
                    }
                });
            }
        });
        this.delayMarkButton.addSelectionListener((SelectionListener)new SelectionListenerImpl<Resource>(context){

            public void apply(WriteGraph graph, Resource input) throws DatabaseException {
                if (input == null) {
                    return;
                }
                SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
                if (graph.hasStatement(input, sr.DependencyConnection_delayMark)) {
                    graph.deny(input, sr.DependencyConnection_delayMark);
                    Layer0Utils.addCommentMetadata((WriteOnlyGraph)graph, (String)("Modified Delay mark for connection " + String.valueOf(graph.getPossibleRelatedValue2(input, Layer0.getInstance((ReadGraph)graph).HasName, (Binding)Bindings.STRING)) + " to False"));
                } else {
                    graph.claim(input, SysdynResource.getInstance((ReadGraph)graph).DependencyConnection_delayMark, null, input);
                    Layer0Utils.addCommentMetadata((WriteOnlyGraph)graph, (String)("Modified Delay mark for connection " + String.valueOf(graph.getPossibleRelatedValue2(input, Layer0.getInstance((ReadGraph)graph).HasName, (Binding)Bindings.STRING)) + " to True"));
                }
            }
        });
    }

    public org.eclipse.swt.widgets.Button getWidget() {
        return this.delayMarkButton.getWidget();
    }
}

