/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.handlers.imports;

import java.io.File;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.simantics.Simantics;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Write;
import org.simantics.sysdyn.modelImport.MdlParser;
import org.simantics.sysdyn.modelImport.model.Model;
import org.simantics.sysdyn.modelImport.model.WriteContext;
import org.simantics.sysdyn.ui.Activator;
import org.simantics.utils.ui.ExceptionUtils;

public class ImportMdlHandler
extends AbstractHandler {
    public static String IMPORTMDLTPATH = "IMPORT_MDL_PATH";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Model model;
        final Resource project = (Resource)Simantics.getProject().get();
        if (project == null) {
            return null;
        }
        Shell shell = HandlerUtil.getActiveShellChecked((ExecutionEvent)event);
        FileDialog fd = new FileDialog(shell, 4096);
        fd.setText("Import .mdl");
        String path = Activator.getDefault().getPreferenceStore().getString(IMPORTMDLTPATH);
        if (path.isEmpty() || !new File(path).exists()) {
            path = Platform.getLocation().toOSString();
        }
        fd.setFilterPath(path);
        String[] filterExt = new String[]{"*.mdl"};
        fd.setFilterExtensions(filterExt);
        String selected = fd.open();
        if (selected == null) {
            return null;
        }
        File file = new File(selected);
        if (!file.isFile()) {
            return null;
        }
        Activator.getDefault().getPreferenceStore().setValue(IMPORTMDLTPATH, new File(selected).getParent());
        try {
            model = new MdlParser().parse(file);
        }
        catch (Exception e) {
            ExceptionUtils.logAndShowError((Throwable)e);
            return null;
        }
        Simantics.getSession().asyncRequest((Write)new WriteRequest(){

            public void perform(WriteGraph graph) throws DatabaseException {
                model.write(graph, project, new WriteContext());
            }
        });
        return null;
    }
}

