/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.elements.connections;

import java.awt.Color;
import java.awt.Font;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.AsyncReadGraph;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.common.utils.ListUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.request.ExternalRead;
import org.simantics.diagram.G2DUtils;
import org.simantics.diagram.adapter.SyncElementFactory;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.stubs.G2DResource;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.diagram.DiagramHints;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.element.ElementClass;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.ElementHandler;
import org.simantics.g2d.element.handler.impl.StaticObjectAdapter;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.expressionParser.ExpressionParser;
import org.simantics.sysdyn.ui.editor.routing.DependencyRouter;
import org.simantics.sysdyn.ui.elements.connections.SysdynConnectionClass;
import org.simantics.sysdyn.ui.preferences.SysdynDiagramPreferences;
import org.simantics.sysdyn.ui.preferences.SysdynDiagramPropertyExternalRead;
import org.simantics.utils.datastructures.Pair;

public class DependencyConnectionFactory
extends SyncElementFactory {
    public static final ElementClass CLASS = SysdynConnectionClass.CLASS;

    public void create(AsyncReadGraph graph, ICanvasContext canvas, IDiagram diagram, Resource elementType, AsyncProcedure<ElementClass> procedure) {
        procedure.execute(graph, (Object)SysdynConnectionClass.CLASS.newClassWith(false, new ElementHandler[]{new StaticObjectAdapter((Object)elementType)}));
    }

    protected Resource getElementClassBaseType(AsyncReadGraph graph) {
        return ((DiagramResource)graph.getService(DiagramResource.class)).Connection;
    }

    public void load(ReadGraph graph, ICanvasContext canvas, IDiagram diagram, Resource elementResource, IElement element) throws DatabaseException {
        element.setHint(DiagramHints.ROUTE_ALGORITHM, (Object)DependencyRouter.INSTANCE);
        G2DResource G2D = G2DResource.getInstance((RequestProcessor)graph.getSession());
        Statement fontStm = graph.getPossibleStatement(elementResource, G2D.HasFont);
        if (fontStm != null && !fontStm.isAsserted(elementResource)) {
            element.setHint(ElementHints.KEY_FONT, (Object)G2DUtils.getFont((ReadGraph)graph, (Resource)fontStm.getObject()));
        } else {
            FontData fd;
            FontData[] fdArray;
            String fontdata = (String)graph.syncRequest((ExternalRead)new SysdynDiagramPropertyExternalRead((Pair<Resource, String>)Pair.make((Object)elementResource, (Object)SysdynDiagramPreferences.ARROW_FONT)));
            if (fontdata != null && (fdArray = PreferenceConverter.basicGetFontData((String)fontdata)) != null && fdArray.length == 1 && (fd = fdArray[0]) != null) {
                Font font = new Font(fd.getName(), fd.getStyle(), fd.getHeight());
                element.setHint(ElementHints.KEY_FONT, (Object)font);
            }
        }
        Statement colorStm = graph.getPossibleStatement(elementResource, G2D.HasColor);
        if (colorStm != null && !colorStm.isAsserted(elementResource)) {
            ElementUtils.setTextColor((IElement)element, (Color)G2DUtils.getColor((ReadGraph)graph, (Resource)colorStm.getObject()));
        } else {
            RGB rgb;
            String color = DependencyConnectionFactory.isForStockInitialOnly(graph, elementResource) ? (String)graph.syncRequest((ExternalRead)new SysdynDiagramPropertyExternalRead((Pair<Resource, String>)new Pair((Object)elementResource, (Object)SysdynDiagramPreferences.ARROW_STOCK_INITIAL_COLOR))) : (String)graph.syncRequest((ExternalRead)new SysdynDiagramPropertyExternalRead((Pair<Resource, String>)new Pair((Object)elementResource, (Object)SysdynDiagramPreferences.ARROW_COLOR)));
            if (color != null && (rgb = StringConverter.asRGB((String)color, null)) != null) {
                Color c = new Color(rgb.red, rgb.green, rgb.blue);
                ElementUtils.setTextColor((IElement)element, (Color)c);
            }
        }
        HashMap<String, Pair> properties = new HashMap<String, Pair>();
        Layer0 l0 = (Layer0)graph.l0();
        for (Resource property : graph.getPredicates(elementResource)) {
            if (!graph.isSubrelationOf(property, l0.HasProperty)) continue;
            Object value = graph.getPossibleRelatedValue(elementResource, property);
            String name = (String)graph.getPossibleRelatedValue(property, l0.HasName, (Binding)Bindings.STRING);
            if (value == null || name == null) continue;
            properties.put(name, Pair.make((Object)property, (Object)value));
        }
        element.setHint(DiagramHints.PROPERTIES, properties);
    }

    protected static boolean isForStockInitialOnly(ReadGraph graph, Resource elementResource) throws DatabaseException {
        Resource head;
        SysdynResource SR = SysdynResource.getInstance((ReadGraph)graph);
        ModelingResources MO = ModelingResources.getInstance((ReadGraph)graph);
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Resource connection = graph.getPossibleObject(elementResource, MO.DiagramConnectionToConnection);
        if (connection == null) {
            return false;
        }
        Resource tail = graph.getPossibleObject(connection, SR.Variable_HasTail);
        if (tail == null) {
            return false;
        }
        if (graph.isInstanceOf(tail, SR.Shadow)) {
            tail = graph.getPossibleObject(tail, SR.Shadow_original);
        }
        if ((head = graph.getPossibleObject(connection, SR.Variable_HasHead)) == null || !graph.isInstanceOf(head, SR.Stock) || tail == null) {
            return false;
        }
        Resource expressionListResource = graph.getPossibleObject(head, SR.Variable_expressionList);
        List expressionList = ListUtils.toPossibleList((ReadGraph)graph, (Resource)expressionListResource);
        boolean initialContainsVariable = false;
        for (Resource expression : expressionList) {
            if (!graph.isInstanceOf(expression, SR.StockExpression)) {
                return false;
            }
            String tailStr = (String)graph.getPossibleRelatedValue(tail, L0.HasName, (Binding)Bindings.STRING);
            String integral = (String)graph.getPossibleRelatedValue(expression, SR.StockExpression_integralEquation, (Binding)Bindings.STRING);
            if (DependencyConnectionFactory.equationContainsVariable(graph, integral, tailStr)) {
                return false;
            }
            String initial = (String)graph.getPossibleRelatedValue(expression, SR.StockExpression_initialEquation, (Binding)Bindings.STRING);
            if (initialContainsVariable || !DependencyConnectionFactory.equationContainsVariable(graph, initial, tailStr)) continue;
            initialContainsVariable = true;
        }
        return initialContainsVariable;
    }

    private static boolean equationContainsVariable(ReadGraph graph, String equation, String variable) {
        ExpressionParser parser = new ExpressionParser((Reader)new StringReader(equation));
        try {
            parser.expr();
        }
        catch (Throwable t) {
            return false;
        }
        Set references = parser.getReferences().keySet();
        return references.contains(variable);
    }
}

