/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modelica.data;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import org.simantics.modelica.data.DataSet;
import org.simantics.modelica.data.SimulationResult;

public class CSVSimulationResult
extends SimulationResult {
    HashMap<String, DataSet> valueMap = new HashMap();

    @Override
    public void read(InputStream stream, int outputInterval) {
        String[] names;
        this.errors.clear();
        String line = CSVSimulationResult.getLine(stream);
        if (line == null) {
            return;
        }
        line = line.substring(1, line.lastIndexOf("\""));
        String[] stringArray = names = line.split("\",\"");
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if (!name.isEmpty()) {
                this.valueMap.put(name, new DataSet(name, new double[this.numberOfLines], new double[this.numberOfLines]));
            }
            ++n2;
        }
        int row = 0;
        while ((line = CSVSimulationResult.getLine(stream)) != null) {
            if (line.isEmpty()) break;
            String[] values = line.split(",");
            int valueIndex = 0;
            while (valueIndex < values.length) {
                if (values[valueIndex] != null && !values[valueIndex].isEmpty() && valueIndex < names.length) {
                    try {
                        this.valueMap.get((Object)names[valueIndex]).values[row] = Double.parseDouble(values[valueIndex]);
                    }
                    catch (NumberFormatException e) {
                        ArrayList<SimulationResult.TimeValuePair> list = (ArrayList<SimulationResult.TimeValuePair>)this.errors.get(names[valueIndex]);
                        if (list == null) {
                            list = new ArrayList<SimulationResult.TimeValuePair>();
                            this.errors.put(names[valueIndex], list);
                        }
                        list.add(new SimulationResult.TimeValuePair(values[0], values[valueIndex]));
                    }
                }
                ++valueIndex;
            }
            ++row;
        }
        for (DataSet ds : this.valueMap.values()) {
            ds.times = this.valueMap.get((Object)"time").values;
            this.variables.add(ds);
        }
    }
}

