/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.jfreechart.chart;

import java.awt.Component;
import java.awt.Frame;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.simantics.Simantics;
import org.simantics.db.AsyncReadGraph;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.AsyncListener;
import org.simantics.db.request.Read;
import org.simantics.jfreechart.chart.IJFreeChart;
import org.simantics.sysdyn.JFreeChartResource;
import org.simantics.utils.RunnableWithObject;

public class ChartComposite
extends Composite {
    private Frame frame;
    private ChartPanel panel;
    private Composite composite;
    private IJFreeChart chart;

    public ChartComposite(Composite parent, String chartResourceURI, int style) {
        super(parent, style | 0x40000 | 0x1000000);
        try {
            Resource chartResource = (Resource)Simantics.getSession().syncRequest(graph -> graph.getPossibleResource(chartResourceURI));
            if (chartResource != null) {
                this.CreateContent(chartResource);
            }
        }
        catch (DatabaseException e2) {
            e2.printStackTrace();
        }
        this.addDisposeListener(e -> this.doDispose());
    }

    public ChartComposite(Composite parent, Resource chartResource, int style) {
        super(parent, style | 0x40000 | 0x1000000);
        this.CreateContent(chartResource);
    }

    public void doDispose() {
        if (this.chart != null) {
            this.chart.dispose();
            this.chart = null;
        }
    }

    private void CreateContent(Resource chartResource) {
        this.composite = this;
        GridLayoutFactory.fillDefaults().applyTo(this.composite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.composite);
        this.frame = SWT_AWT.new_Frame((Composite)this.composite);
        Simantics.getSession().asyncRequest((Read)new ChartRead(chartResource), (AsyncListener)new AsyncListener<IJFreeChart>(){

            public boolean isDisposed() {
                return ChartComposite.this.composite.isDisposed();
            }

            public void execute(AsyncReadGraph graph, IJFreeChart chart) {
                if (chart == null || ChartComposite.this.composite.isDisposed()) {
                    return;
                }
                if (ChartComposite.this.chart != null) {
                    ChartComposite.this.chart.dispose();
                }
                ChartComposite.this.chart = chart;
                JFreeChart jfreeChart = chart.getChart();
                if (ChartComposite.this.composite.isDisposed()) {
                    return;
                }
                ChartComposite.this.composite.getDisplay().asyncExec((Runnable)new RunnableWithObject(jfreeChart){

                    public void run() {
                        if ((this).ChartComposite.this.composite.isDisposed()) {
                            return;
                        }
                        if ((this).ChartComposite.this.panel != null) {
                            (this).ChartComposite.this.frame.remove((Component)(this).ChartComposite.this.panel);
                        }
                        (this).ChartComposite.this.composite.layout();
                        JFreeChart chart = (JFreeChart)this.getObject();
                        (this).ChartComposite.this.panel = new ChartPanel(chart, 1024, 768, 300, 200, 2048, 1536, false, false, true, true, true, true);
                        (this).ChartComposite.this.frame.add((Component)(this).ChartComposite.this.panel);
                        (this).ChartComposite.this.frame.validate();
                    }
                });
            }

            public void exception(AsyncReadGraph graph, Throwable throwable) {
                throwable.printStackTrace();
            }
        });
    }

    protected static class ChartRead
    implements Read<IJFreeChart> {
        private Resource chartResource;

        public ChartRead(Resource chartResource) {
            this.chartResource = chartResource;
        }

        public IJFreeChart perform(ReadGraph graph) throws DatabaseException {
            if (graph.isInstanceOf(this.chartResource, JFreeChartResource.getInstance((ReadGraph)graph).Chart)) {
                return (IJFreeChart)graph.adaptUnique(this.chartResource, IJFreeChart.class);
            }
            return null;
        }
    }
}

