/*
 * Decompiled with CFR 0.152.
 */
package fi.semantum.sysdyn.solver;

import fi.semantum.sysdyn.solver.Argument;
import fi.semantum.sysdyn.solver.Array;
import fi.semantum.sysdyn.solver.Assignment;
import fi.semantum.sysdyn.solver.CodeCache;
import fi.semantum.sysdyn.solver.Constant;
import fi.semantum.sysdyn.solver.Environment;
import fi.semantum.sysdyn.solver.Model;
import fi.semantum.sysdyn.solver.ParameterDeclaration;
import fi.semantum.sysdyn.solver.UnassignedVariableException;
import fi.semantum.sysdyn.solver.Variable;
import fi.semantum.sysdyn.solver.VariableBase;
import fi.semantum.sysdyn.solver.VariableDeclaration;
import java.util.ArrayList;

public class Solver {
    private static final boolean VALIDATE = true;
    private static final boolean PRINT_EXCEPTIONS = false;
    private static final int STACK_SIZE = 1000;
    private static final int MAX_LOOPS = 50;
    private Model model;
    private Environment env;
    private Object[] newValues;
    private double defaultStep = 0.1;
    private double start = 0.0;
    private boolean ready = false;
    private boolean dirty;
    private boolean started;

    public void setStep(double step) {
        this.defaultStep = step;
        if (this.env != null) {
            this.env.step = step;
        }
    }

    public void setStart(double start) {
        this.start = start;
        this.ready = false;
    }

    private void validate(Variable var, Object value) {
        if (value instanceof Double) {
            if (Double.isNaN((Double)value)) {
                System.err.println("value is invalid (NaN): " + var.base.name);
                throw new IllegalStateException("value is invalid (NaN): " + var.base.name);
            }
            if (Double.isInfinite((Double)value)) {
                System.err.println("value is invalid (Infinite): " + var.base.name);
                throw new IllegalStateException("value is invalid (Infinite): " + var.base.name);
            }
        }
        if (value instanceof Array) {
            for (Object o : ((Array)value).elements()) {
                this.validate(var, o);
            }
        }
    }

    public void prepare(String input) throws Exception {
        this.model = CodeCache.getInstance().getModel(input);
        int size = this.model.getSize();
        this.env = new Environment(this.model, this.defaultStep, this.start);
        this.env.setSize(size);
        this.env.valueTable = new Object[size + 1000];
        this.newValues = new Object[Math.max(this.model.assignments.size(), this.model.derivatives.size())];
        int condition = 1;
        int loops = 0;
        StringBuilder errors = null;
        ArrayList<Assignment> assignments = new ArrayList<Assignment>();
        assignments.addAll(this.model.assignments);
        assignments.addAll(this.model.initials);
        while (condition > 0 && loops++ < 50) {
            String error2;
            if (loops == 50) {
                errors = new StringBuilder();
            }
            condition = 0;
            for (ParameterDeclaration pd : this.model.parameters) {
                try {
                    if (this.env.isAssigned(pd)) continue;
                    Object value = pd.modification.evaluate(this.env);
                    this.validate(pd.variable, value);
                    pd.variable.assign(this.env, null, value);
                    this.env.setAssigned(pd);
                }
                catch (Exception e) {
                    error2 = "  -" + pd.variable.toString() + ": " + e.getMessage();
                    if (errors != null) {
                        errors.append(error2);
                        errors.append("\n");
                    }
                    ++condition;
                }
            }
            for (VariableDeclaration vd : this.model.variables) {
                try {
                    if (this.env.isAssigned(vd)) continue;
                    Argument[] argumentArray = vd.modification.args;
                    int n = vd.modification.args.length;
                    int error2 = 0;
                    while (error2 < n) {
                        Argument arg = argumentArray[error2];
                        if (arg.name.endsWith("start")) {
                            Object value = arg.modification.evaluate(this.env);
                            if (vd.variable.base.dimension() == 1) {
                                this.validate(vd.variable, value);
                                vd.variable.assign(this.env, null, value);
                            } else {
                                this.validate(vd.variable, value);
                                if (value instanceof Double) {
                                    Array array = new Array();
                                    int i = 0;
                                    while (i < vd.variable.base.dimension()) {
                                        array.addElement(value);
                                        ++i;
                                    }
                                    vd.variable.assign(this.env, null, array);
                                } else if (value instanceof Array) {
                                    vd.variable.assign(this.env, null, value);
                                } else {
                                    throw new IllegalStateException();
                                }
                            }
                            for (Assignment a : assignments) {
                                if (!vd.variable.base.equals(a.target.base)) continue;
                                this.env.setAssigned(a);
                            }
                        }
                        ++error2;
                    }
                }
                catch (Exception e) {
                    error2 = "  -" + vd.variable.toString() + ": " + e.getMessage();
                    if (errors != null) {
                        errors.append(error2);
                        errors.append("\n");
                    }
                    ++condition;
                }
            }
            for (Assignment ass : assignments) {
                try {
                    if (this.env.isAssigned(ass)) continue;
                    ass.assign(this.env);
                }
                catch (UnassignedVariableException e) {
                    ++condition;
                }
                catch (Exception e) {
                    error2 = "  -" + ass.target.toString() + ": " + e.getMessage();
                    if (errors != null) {
                        errors.append(error2);
                        errors.append("\n");
                    }
                    ++condition;
                }
            }
        }
        if (loops == 51) {
            throw new IllegalStateException("Did not find initial state for model:\n" + errors.toString());
        }
        for (Assignment ass : this.model.assignments) {
            if (!(ass.expression instanceof Constant)) continue;
            ass.isConstant = true;
        }
        this.env.initial = false;
        this.ready = true;
        this.started = false;
        this.dirty = false;
    }

    public String[] keys() {
        return this.env.getValueKeyArray();
    }

    public double[] values() {
        return this.env.getValueArray();
    }

    public void aboutToRun() {
        if (!this.started || this.dirty) {
            int loop = 0;
            while (loop < 3) {
                Assignment[] assignments = this.model.assignmentArray;
                int i = 0;
                while (i < assignments.length) {
                    if (!assignments[i].isConstant) {
                        assignments[i].assign(this.env);
                    }
                    ++i;
                }
                if (!this.started) {
                    for (Assignment ass : this.model.initials) {
                        if (ass.isConstant) continue;
                        ass.assign(this.env);
                    }
                    for (VariableDeclaration vd : this.model.variables) {
                        try {
                            Argument[] argumentArray = vd.modification.args;
                            int n = vd.modification.args.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Argument arg = argumentArray[n2];
                                if (arg.name.endsWith("start")) {
                                    Object value = arg.modification.evaluate(this.env);
                                    if (vd.variable.base.dimension() == 1) {
                                        this.validate(vd.variable, value);
                                        vd.variable.assign(this.env, null, value);
                                    } else {
                                        this.validate(vd.variable, value);
                                        if (value instanceof Double) {
                                            Array array = new Array();
                                            int i2 = 0;
                                            while (i2 < vd.variable.base.dimension()) {
                                                array.addElement(value);
                                                ++i2;
                                            }
                                            vd.variable.assign(this.env, null, array);
                                        } else if (value instanceof Array) {
                                            vd.variable.assign(this.env, null, value);
                                        } else {
                                            throw new IllegalStateException();
                                        }
                                    }
                                }
                                ++n2;
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                ++loop;
            }
            this.dirty = false;
        }
    }

    public void step() {
        if (!this.ready) {
            return;
        }
        this.started = true;
        Assignment[] assignments = this.model.assignmentArray;
        Assignment[] derivatives = this.model.derivativeArray;
        int i = 0;
        while (i < this.model.derivatives.size()) {
            this.newValues[i] = derivatives[i].expression.evaluate(this.env);
            ++i;
        }
        i = 0;
        while (i < this.model.derivatives.size()) {
            derivatives[i].target.assign(this.env, derivatives[i].subscripts, this.newValues[i]);
            ++i;
        }
        this.env.time += this.env.step;
        VariableBase base = this.model.names.get("time");
        if (base != null) {
            this.env.put(base.index, (Object)this.env.time);
        }
        int i2 = 0;
        while (i2 < assignments.length) {
            if (!assignments[i2].isConstant) {
                assignments[i2].assign(this.env);
            }
            ++i2;
        }
    }

    public void printEnvironment() {
        String[] keys = this.keys();
        double[] values = this.values();
        System.err.println("Environment " + keys.length + " " + values.length);
        int i = 0;
        while (i < keys.length) {
            System.err.println(keys[i] + " = " + values[i]);
            ++i;
        }
    }

    public double getTime() {
        if (this.env != null) {
            return this.env.time;
        }
        return 0.0;
    }

    public void setValue(String key, double value) {
        this.env.setValue(key, value);
        this.dirty = true;
    }
}

