/*
 * Decompiled with CFR 0.152.
 */
package fi.semantum.sysdyn.solver;

import fi.semantum.sysdyn.solver.Array;
import fi.semantum.sysdyn.solver.ForIndex;
import fi.semantum.sysdyn.solver.IEnvironment;
import fi.semantum.sysdyn.solver.IStatement;
import java.util.ArrayList;

public class ForStatement
implements IStatement {
    public ArrayList<ForIndex> indices;
    public IStatement statement;

    public ForStatement(ArrayList<ForIndex> indices, IStatement statement) {
        this.indices = indices;
        this.statement = statement;
    }

    public String toString() {
        return "for " + String.valueOf(this.indices) + " loop " + String.valueOf(this.statement) + " end for";
    }

    private IStatement.ReturnValue loop(IEnvironment environment, int i) {
        if (i == this.indices.size()) {
            IStatement.ReturnValue ret = this.statement.evaluate(environment);
            if (IStatement.ReturnValue.BREAK.equals((Object)ret)) {
                return IStatement.ReturnValue.CONTINUE;
            }
            if (IStatement.ReturnValue.RETURN.equals((Object)ret)) {
                return IStatement.ReturnValue.RETURN;
            }
            return IStatement.ReturnValue.CONTINUE;
        }
        ForIndex index = this.indices.get(i);
        Array array = (Array)index.expression.evaluate(environment);
        for (Object element : array.elements()) {
            environment.put(index.base.index, element);
            IStatement.ReturnValue ret = this.loop(environment, i + 1);
            if (IStatement.ReturnValue.BREAK.equals((Object)ret)) {
                return IStatement.ReturnValue.CONTINUE;
            }
            if (!IStatement.ReturnValue.RETURN.equals((Object)ret)) continue;
            return IStatement.ReturnValue.RETURN;
        }
        return IStatement.ReturnValue.CONTINUE;
    }

    @Override
    public IStatement.ReturnValue evaluate(IEnvironment environment) {
        return this.loop(environment, 0);
    }
}

