/*
 * Decompiled with CFR 0.152.
 */
package fi.semantum.sysdyn.solver;

import fi.semantum.sysdyn.solver.Array;
import fi.semantum.sysdyn.solver.IEnvironment;
import fi.semantum.sysdyn.solver.IExpression;
import fi.semantum.sysdyn.solver.IFrame;
import fi.semantum.sysdyn.solver.VariableBase;
import java.util.Map;

public class ArraySliceExpression
implements IExpression {
    public IExpression start;
    public IExpression end;

    public ArraySliceExpression(IExpression start, IExpression end) {
        this.start = start;
        this.end = end;
    }

    public String toString() {
        return String.valueOf(this.start) + ":" + String.valueOf(this.end);
    }

    @Override
    public Object evaluate(IEnvironment environment) {
        Double s = (Double)this.start.evaluate(environment);
        Double e = (Double)this.end.evaluate(environment);
        Array result = new Array();
        int i = s.intValue();
        while (i <= e.intValue()) {
            result.addElement(i);
            ++i;
        }
        return result;
    }

    @Override
    public IExpression withBase(IFrame frame, String prefix) {
        return new ArraySliceExpression(this.start.withBase(frame, prefix), this.end.withBase(frame, prefix));
    }

    @Override
    public Object getPossibleConstant() {
        return null;
    }

    @Override
    public IExpression rewrite(IFrame frame, Map<String, VariableBase> copies) {
        this.start = this.start.rewrite(frame, copies);
        this.end = this.end.rewrite(frame, copies);
        return this;
    }

    @Override
    public void accept(IExpression.ExpressionVisitor visitor) {
        visitor.visit(this);
        this.start.accept(visitor);
        this.end.accept(visitor);
    }
}

