/*
 * Decompiled with CFR 0.152.
 */
package winterwell.markdown.pagemodel;

import com.petebevin.markdown.MarkdownProcessor;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.preference.IPreferenceStore;
import winterwell.markdown.Activator;
import winterwell.markdown.StringMethods;
import winterwell.utils.FailureException;
import winterwell.utils.Process;
import winterwell.utils.StrUtils;
import winterwell.utils.Utils;
import winterwell.utils.io.FileUtils;

public class MarkdownPage {
    private List<String> lines;
    private List<KLineType> lineTypes;
    private Map<Integer, Object> pageObjects = new HashMap<Integer, Object>();
    private static Pattern multiMarkdownTag = Pattern.compile("^([\\w].*):(.*)");
    private Map<String, String> multiMarkdownTags = new HashMap<String, String>();
    private static Pattern githubURLDetection = Pattern.compile("((https?|ftp|file)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|])");
    private final List<Header> level1Headers = new ArrayList<Header>();
    private final IPreferenceStore pStore = Activator.getDefault().getPreferenceStore();

    private String cleanHeader(String line) {
        char c;
        int j = 0;
        while (j < line.length()) {
            c = line.charAt(j);
            if (c != '#' && !Character.isWhitespace(c)) {
                line = line.substring(j);
                break;
            }
            ++j;
        }
        j = line.length() - 1;
        while (j > 0) {
            c = line.charAt(j);
            if (c != '#' && !Character.isWhitespace(c)) {
                line = line.substring(0, j + 1);
                break;
            }
            --j;
        }
        return line;
    }

    public List<String> getText() {
        return Collections.unmodifiableList(this.lines);
    }

    public MarkdownPage(String text) {
        this.setText(text);
    }

    private void setText(String text) {
        boolean githubSyntaxSupport;
        Matcher m;
        this.lines = StringMethods.splitLines(text);
        this.level1Headers.clear();
        this.lineTypes = new ArrayList<KLineType>(this.lines.size());
        this.pageObjects.clear();
        Header dummyTopHeader = new Header(1, 0, "", null);
        this.level1Headers.add(dummyTopHeader);
        Header currentHeader = dummyTopHeader;
        int lineNum = 0;
        boolean multiMarkdownMetadataSupport = this.pStore.getBoolean("Pref_MultiMarkdown_Metadata");
        if (multiMarkdownMetadataSupport) {
            boolean validMetadata = true;
            lineNum = 0;
            while (lineNum < this.lines.size()) {
                String line = this.lines.get(lineNum);
                if (Utils.isBlank((CharSequence)line)) break;
                Matcher m2 = multiMarkdownTag.matcher(line);
                if (!m2.find()) {
                    if (lineNum == 0) {
                        validMetadata = false;
                        break;
                    }
                    if (!line.matches("^\\s.*\n")) {
                        validMetadata = false;
                        break;
                    }
                }
                ++lineNum;
            }
            if (validMetadata) {
                Object data = "";
                String tag = "";
                lineNum = 0;
                while (lineNum < this.lines.size()) {
                    String line = this.lines.get(lineNum);
                    if (Utils.isBlank((CharSequence)line)) break;
                    m = multiMarkdownTag.matcher(line);
                    if (!m.find()) {
                        if (lineNum == 0) break;
                        this.lineTypes.add(KLineType.META);
                        data = (String)data + StrUtils.LINEEND + line.trim();
                        this.multiMarkdownTags.put(tag, (String)data);
                    } else {
                        this.lineTypes.add(KLineType.META);
                        tag = m.group(0);
                        data = m.group(1).trim();
                        if (m.group(1).endsWith(line)) {
                            this.multiMarkdownTags.put(tag, (String)data);
                        }
                    }
                    ++lineNum;
                }
            } else {
                lineNum = 0;
            }
        }
        while (lineNum < this.lines.size()) {
            String line = this.lines.get(lineNum);
            int h = this.numHash(line);
            String hLine = line;
            int hLineNum = lineNum;
            int underline = -1;
            if (lineNum != 0) {
                int n = this.just(line, '=') ? 1 : (underline = this.just(line, '-') ? 2 : -1);
            }
            if (underline != -1) {
                h = underline;
                hLineNum = lineNum - 1;
                hLine = this.lines.get(lineNum - 1);
                this.lineTypes.set(hLineNum, KLineType.values()[h]);
                this.lineTypes.add(KLineType.MARKER);
            }
            if (h > 0) {
                if (underline == -1) {
                    this.lineTypes.add(KLineType.values()[h]);
                }
                Header header = new Header(h, hLineNum, hLine, currentHeader);
                if (h == 1) {
                    this.level1Headers.add(header);
                }
                this.pageObjects.put(hLineNum, header);
                currentHeader = header;
            } else if (Utils.isBlank((CharSequence)line)) {
                this.lineTypes.add(KLineType.BLANK);
            } else {
                this.lineTypes.add(KLineType.NORMAL);
            }
            ++lineNum;
        }
        if (dummyTopHeader.getSubHeaders().size() == 0) {
            this.level1Headers.remove(dummyTopHeader);
        }
        if (githubSyntaxSupport = this.pStore.getBoolean("Pref_Github_Syntax")) {
            Object line;
            boolean inCodeBlock = false;
            lineNum = 0;
            while (lineNum < this.lines.size()) {
                line = this.lines.get(lineNum);
                if (((String)line).matches("^```.*\n")) {
                    inCodeBlock = !inCodeBlock;
                    this.lines.set(lineNum, "\n");
                    this.lineTypes.set(lineNum, KLineType.NORMAL);
                } else if (inCodeBlock) {
                    this.lines.set(lineNum, "    " + (String)line);
                }
                ++lineNum;
            }
            lineNum = 0;
            while (lineNum < this.lines.size()) {
                boolean urlReplaced;
                line = this.lines.get(lineNum);
                block5: do {
                    urlReplaced = false;
                    m = githubURLDetection.matcher((CharSequence)line);
                    while (m.find()) {
                        if (m.start() - 1 >= 0 && m.end() < ((String)line).length() && ((String)line).charAt(m.start() - 1) == '<' && ((String)line).charAt(m.end()) == '>' || m.start() - 2 >= 0 && m.end() < ((String)line).length() && ((String)line).charAt(m.start() - 2) == ']' && ((String)line).charAt(m.start() - 1) == '(' && ((String)line).charAt(m.end()) == ')' || m.start() - 2 >= 0 && m.end() + 1 < ((String)line).length() && ((String)line).charAt(m.start() - 2) == ']' && ((String)line).charAt(m.start() - 1) == '(' && ((String)line).charAt(m.end()) == ' ' && ((String)line).charAt(m.end() + 1) == '\"') continue;
                        line = m.start() - 1 >= 0 ? ((String)line).substring(0, m.start()) + "<" + m.group(0) + ">" + ((String)line).substring(m.end()) : "<" + m.group(0) + ">" + ((String)line).substring(m.end());
                        this.lines.set(lineNum, (String)line);
                        urlReplaced = true;
                        continue block5;
                    }
                } while (urlReplaced);
                ++lineNum;
            }
        }
    }

    boolean just(String line, char c) {
        return line.matches("\\s*" + c + "+\\s*");
    }

    private int numHash(String line) {
        int i = 0;
        while (i < line.length()) {
            if (line.charAt(i) != '#') {
                return i;
            }
            ++i;
        }
        return line.length();
    }

    public List<Header> getHeadings(Header parent) {
        if (parent == null) {
            return Collections.unmodifiableList(this.level1Headers);
        }
        return Collections.unmodifiableList(parent.subHeaders);
    }

    public String html() {
        boolean sectionNumbers = this.pStore.getBoolean("Pref_SectionNumbers");
        StringBuilder sb = new StringBuilder();
        assert (this.lines.size() == this.lineTypes.size());
        int i = 0;
        int n = this.lines.size();
        while (i < n) {
            KLineType type = this.lineTypes.get(i);
            if (type != KLineType.META) {
                String line = this.lines.get(i);
                if (sectionNumbers && this.isHeader(type)) {
                    line.contains("$section");
                }
                sb.append(line);
            }
            ++i;
        }
        String text = sb.toString();
        String cmd = this.pStore.getString("Pref_Markdown_Command");
        if (Utils.isBlank((CharSequence)cmd) || cmd.startsWith("(") && cmd.contains("MarkdownJ")) {
            MarkdownProcessor markdown = new MarkdownProcessor();
            text = text.replace("\u00a3", "&pound;");
            String html = markdown.markdown(text);
            return html;
        }
        try {
            File md = File.createTempFile("tmp", ".md");
            FileUtils.write((File)md, (CharSequence)text);
            Process process = new Process(cmd + " " + md.getAbsolutePath());
            process.run();
            int ok = process.waitFor(10000L);
            if (ok != 0) {
                throw new FailureException(cmd + " failed:\n" + process.getError());
            }
            String html = process.getOutput();
            FileUtils.delete((File)md);
            return html;
        }
        catch (Exception e) {
            throw Utils.runtime((Throwable)e);
        }
    }

    private boolean isHeader(KLineType type) {
        return type == KLineType.H1 || type == KLineType.H2 || type == KLineType.H3 || type == KLineType.H4 || type == KLineType.H5 || type == KLineType.H6;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (String line : this.lines) {
            sb.append(line);
        }
        return sb.toString();
    }

    public List<KLineType> getLineTypes() {
        return Collections.unmodifiableList(this.lineTypes);
    }

    public Object getPageObject(int line) {
        return this.pageObjects.get(line);
    }

    public class Header {
        final int level;
        final String heading;
        final List<Header> subHeaders = new ArrayList<Header>();
        final int lineNumber;
        private Header parent;

        public int getLineNumber() {
            return this.lineNumber;
        }

        public Header getNext() {
            if (this.parent == null) {
                int ti = MarkdownPage.this.level1Headers.indexOf(this);
                if (ti == -1 || ti == MarkdownPage.this.level1Headers.size() - 1) {
                    return null;
                }
                return MarkdownPage.this.level1Headers.get(ti + 1);
            }
            int i = this.parent.subHeaders.indexOf(this);
            assert (i != -1) : this;
            if (i == this.parent.subHeaders.size() - 1) {
                return this.parent.getNext();
            }
            return this.parent.subHeaders.get(i + 1);
        }

        public Header getPrevious() {
            if (this.parent == null) {
                int ti = MarkdownPage.this.level1Headers.indexOf(this);
                if (ti == -1 || ti == 0) {
                    return null;
                }
                return MarkdownPage.this.level1Headers.get(ti - 1);
            }
            int i = this.parent.subHeaders.indexOf(this);
            assert (i != -1) : this;
            if (i == 0) {
                return this.parent.getPrevious();
            }
            return this.parent.subHeaders.get(i - 1);
        }

        Header(int level, int lineNumber, String heading, Header currentHeader) {
            this.lineNumber = lineNumber;
            this.level = level;
            this.heading = MarkdownPage.this.cleanHeader(heading);
            this.setParent(currentHeader);
        }

        private void setParent(Header currentHeader) {
            if (currentHeader == null) {
                this.parent = null;
                return;
            }
            if (currentHeader.level < this.level) {
                this.parent = currentHeader;
                this.parent.subHeaders.add(this);
                return;
            }
            this.setParent(currentHeader.parent);
        }

        public Header getParent() {
            return this.parent;
        }

        public List<Header> getSubHeaders() {
            return this.subHeaders;
        }

        public String toString() {
            return this.heading;
        }

        public int getLevel() {
            return this.level;
        }
    }

    public static enum KLineType {
        NORMAL,
        H1,
        H2,
        H3,
        H4,
        H5,
        H6,
        BLANK,
        MARKER,
        META;

    }
}

