/*
 * Decompiled with CFR 0.152.
 */
package winterwell.markdown.editors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;
import winterwell.markdown.editors.MarkdownEditor;
import winterwell.markdown.pagemodel.MarkdownPage;
import winterwell.utils.StrUtils;
import winterwell.utils.Utils;
import winterwell.utils.web.WebUtils;

public final class MarkdownContentOutlinePage
extends ContentOutlinePage {
    private Object fInput = null;
    private final IDocumentProvider fDocumentProvider;
    private final MarkdownEditor fTextEditor;
    protected boolean showWordCounts;
    private List<MarkdownPage.Header> selectedHeaders;

    public MarkdownContentOutlinePage(IDocumentProvider documentProvider, MarkdownEditor mdEditor) {
        this.fDocumentProvider = documentProvider;
        this.fTextEditor = mdEditor;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        TreeViewer viewer = this.getTreeViewer();
        viewer.setContentProvider((IContentProvider)new ContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (!(element instanceof MarkdownPage.Header)) {
                    return super.getText(element);
                }
                MarkdownPage.Header header = (MarkdownPage.Header)element;
                String hText = header.toString();
                if (!MarkdownContentOutlinePage.this.showWordCounts) {
                    return hText;
                }
                IRegion region = MarkdownContentOutlinePage.this.getRegion(header);
                try {
                    String text = MarkdownContentOutlinePage.this.fTextEditor.getDocument().get(region.getOffset(), region.getLength());
                    text = WebUtils.stripTags((String)text);
                    text = text.replaceAll("#", "").trim();
                    if (!$assertionsDisabled && !text.startsWith(hText)) {
                        throw new AssertionError();
                    }
                    text = text.substring(hText.length());
                    int wc = StrUtils.wordCount((String)text);
                    return hText + " (" + wc + ":" + text.length() + ")";
                }
                catch (BadLocationException badLocationException) {
                    return hText;
                }
            }
        });
        viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        if (this.fInput != null) {
            viewer.setInput(this.fInput);
        }
        IPageSite site = this.getSite();
        IActionBars bars = site.getActionBars();
        IToolBarManager toolbar = bars.getToolBarManager();
        Action action = new Action("123", 2){

            public void run() {
                MarkdownContentOutlinePage.this.showWordCounts = this.isChecked();
                MarkdownContentOutlinePage.this.update();
            }
        };
        action.setToolTipText("Show/hide section word:character counts");
        toolbar.add((IAction)action);
        action = new Action("<"){

            public void run() {
                MarkdownContentOutlinePage.this.doPromoteDemote(-1);
            }
        };
        action.setToolTipText("Promote the selected section\n -- move it up a level.");
        toolbar.add((IAction)action);
        action = new Action(">"){

            public void run() {
                MarkdownContentOutlinePage.this.doPromoteDemote(1);
            }
        };
        action.setToolTipText("Demote the selected section\n -- move it down a level.");
        toolbar.add((IAction)action);
        action = new Action("/\\"){

            public void run() {
                try {
                    MarkdownContentOutlinePage.this.doMove(-1);
                }
                catch (BadLocationException e) {
                    throw Utils.runtime((Throwable)e);
                }
            }
        };
        action.setToolTipText("Move the selected section earlier");
        toolbar.add((IAction)action);
        action = new Action("\\/"){

            public void run() {
                try {
                    MarkdownContentOutlinePage.this.doMove(1);
                }
                catch (BadLocationException e) {
                    throw Utils.runtime((Throwable)e);
                }
            }
        };
        action.setToolTipText("Move the selected section later");
        toolbar.add((IAction)action);
        ImageDescriptor id = ImageDescriptor.createFromFile(((Object)((Object)this)).getClass(), (String)"collapseall.gif");
        action = new Action("collapse", id){

            public void run() {
                MarkdownContentOutlinePage.this.doCollapseAll();
            }
        };
        action.setImageDescriptor(id);
        action.setToolTipText("Collapse outline tree");
        toolbar.add((IAction)action);
        id = ImageDescriptor.createFromFile(((Object)((Object)this)).getClass(), (String)"synced.gif");
        action = new Action("sync"){

            public void run() {
                try {
                    MarkdownContentOutlinePage.this.doSyncToEditor();
                }
                catch (BadLocationException e) {
                    throw Utils.runtime((Throwable)e);
                }
            }
        };
        action.setImageDescriptor(id);
        action.setToolTipText("Link with editor");
        toolbar.add((IAction)action);
        viewer.getControl().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x100000B) {
                    MarkdownContentOutlinePage.this.doEditHeader();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
    }

    protected void doSyncToEditor() throws BadLocationException {
        TreeViewer viewer = this.getTreeViewer();
        if (viewer == null) {
            return;
        }
        MarkdownPage page = this.fTextEditor.getMarkdownPage();
        int caretOffset = this.fTextEditor.getViewer().getTextWidget().getCaretOffset();
        IDocument doc = this.fTextEditor.getDocument();
        int line = doc.getLineOfOffset(caretOffset);
        List<MarkdownPage.KLineType> lineTypes = page.getLineTypes();
        while (line > -1) {
            MarkdownPage.KLineType lt = lineTypes.get(line);
            if (lt.toString().startsWith("H")) break;
            --line;
        }
        if (line < 0) {
            return;
        }
        MarkdownPage.Header header = (MarkdownPage.Header)page.getPageObject(line);
        StructuredSelection selection = new StructuredSelection((Object)header);
        viewer.setSelection((ISelection)selection, true);
    }

    void doEditHeader() {
        TreeViewer viewer = this.getTreeViewer();
        viewer.editElement((Object)this.selectedHeaders.get(0), 0);
    }

    protected void doCollapseAll() {
        TreeViewer viewer = this.getTreeViewer();
        if (viewer == null) {
            return;
        }
        viewer.collapseAll();
    }

    protected void doMove(int i) throws BadLocationException {
        Object post;
        Object pre;
        int insert;
        assert (i == 1 || i == -1);
        if (this.selectedHeaders == null || this.selectedHeaders.size() == 0) {
            return;
        }
        MarkdownPage.Header first = this.selectedHeaders.get(0);
        MarkdownPage.Header last = this.selectedHeaders.get(this.selectedHeaders.size() - 1);
        int start = this.fTextEditor.getDocument().getLineOffset(first.getLineNumber());
        IRegion r = this.getRegion(last);
        int end = r.getOffset() + r.getLength();
        if (i == 1) {
            MarkdownPage.Header nextSection = last.getNext();
            if (nextSection == null) {
                return;
            }
            nr = this.getRegion(nextSection);
            insert = nr.getOffset() + nr.getLength();
        } else {
            MarkdownPage.Header prevSection = first.getPrevious();
            if (prevSection == null) {
                return;
            }
            nr = this.getRegion(prevSection);
            insert = nr.getOffset();
        }
        Object text = this.fTextEditor.getDocument().get();
        String section = ((String)text).substring(start, end);
        if (i == 1) {
            pre = ((String)text).substring(0, start) + ((String)text).substring(end, insert);
            post = ((String)text).substring(insert);
        } else {
            pre = ((String)text).substring(0, insert);
            post = ((String)text).substring(insert, start) + ((String)text).substring(end);
        }
        text = (String)pre + section + (String)post;
        assert (((String)text).length() == this.fTextEditor.getDocument().get().length()) : ((String)text).length() - this.fTextEditor.getDocument().get().length() + " chars gained/lost";
        this.fTextEditor.getDocument().set((String)text);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void doPromoteDemote(int upDown) {
        assert (upDown == 1 || upDown == -1);
        if (this.selectedHeaders == null || this.selectedHeaders.size() == 0) {
            return;
        }
        HashSet<MarkdownPage.Header> toAdjust = new HashSet<MarkdownPage.Header>(this.selectedHeaders);
        HashSet<MarkdownPage.Header> adjusted = new HashSet<MarkdownPage.Header>();
        MarkdownPage mdPage = this.fTextEditor.getMarkdownPage();
        ArrayList<String> lines = new ArrayList<String>(mdPage.getText());
        while (toAdjust.size() != 0) {
            void var7_7;
            MarkdownPage.Header h = toAdjust.iterator().next();
            toAdjust.remove(h);
            adjusted.add(h);
            String string = (String)lines.get(h.getLineNumber());
            if (upDown == -1) {
                if (h.getLevel() == 1) {
                    return;
                }
                if (!string.startsWith("##")) return;
                String string2 = string.substring(1);
            } else {
                String string3 = "#" + string;
            }
            int ln = h.getLineNumber();
            lines.set(ln, (String)var7_7);
            ArrayList<MarkdownPage.Header> kids = new ArrayList<MarkdownPage.Header>(h.getSubHeaders());
            for (MarkdownPage.Header header : kids) {
                if (adjusted.contains(header)) continue;
                toAdjust.add(header);
            }
        }
        StringBuilder sb = new StringBuilder();
        for (String string : lines) {
            sb.append(string);
        }
        this.fTextEditor.getDocument().set(sb.toString());
    }

    protected IRegion getRegion(MarkdownPage.Header header) {
        try {
            IDocument doc = this.fTextEditor.getDocument();
            int start = header.getLineNumber();
            MarkdownPage.Header next = header.getNext();
            int end = next != null ? next.getLineNumber() - 1 : doc.getNumberOfLines() - 1;
            int offset = doc.getLineOffset(start);
            IRegion ei = doc.getLineInformation(end);
            int length = ei.getOffset() + ei.getLength() - offset;
            return new Region(offset, length);
        }
        catch (BadLocationException ex) {
            throw Utils.runtime((Throwable)ex);
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        super.selectionChanged(event);
        this.selectedHeaders = null;
        ISelection selection = event.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        try {
            int length;
            IStructuredSelection strucSel = (IStructuredSelection)selection;
            Object[] sections = strucSel.toArray();
            this.selectedHeaders = Arrays.asList(sections);
            MarkdownPage.Header first = (MarkdownPage.Header)sections[0];
            MarkdownPage.Header last = (MarkdownPage.Header)sections[sections.length - 1];
            int start = this.fTextEditor.getDocument().getLineOffset(first.getLineNumber());
            if (first == last) {
                length = this.fTextEditor.getDocument().getLineLength(first.getLineNumber());
            } else {
                IRegion r = this.getRegion(last);
                int end = r.getOffset() + r.getLength();
                length = end - start;
            }
            this.fTextEditor.setHighlightRange(start, length, true);
        }
        catch (Exception x) {
            System.out.println(x.getStackTrace());
            this.fTextEditor.resetHighlightRange();
        }
    }

    public void setInput(Object input) {
        this.fInput = input;
        this.update();
    }

    public void update() {
        Control control;
        TreeViewer viewer = this.getTreeViewer();
        if (viewer != null && (control = viewer.getControl()) != null && !control.isDisposed()) {
            control.setRedraw(false);
            viewer.setInput(this.fInput);
            viewer.expandAll();
            control.setRedraw(true);
        }
    }

    public final class ContentProvider
    implements ITreeContentProvider,
    IDocumentListener {
        private MarkdownPage fContent;
        private MarkdownEditor fTextEditor;

        private void parse() {
            this.fContent = this.fTextEditor.getMarkdownPage();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            IDocument document;
            if (oldInput != null && (document = MarkdownContentOutlinePage.this.fDocumentProvider.getDocument(oldInput)) != null) {
                document.removeDocumentListener((IDocumentListener)this);
            }
            this.fContent = null;
            if (newInput == null) {
                return;
            }
            document = MarkdownContentOutlinePage.this.fDocumentProvider.getDocument(newInput);
            if (document == null) {
                return;
            }
            this.fTextEditor = MarkdownEditor.getEditor(document);
            document.addDocumentListener((IDocumentListener)this);
            this.parse();
        }

        public void dispose() {
            this.fContent = null;
        }

        public boolean isDeleted(Object element) {
            return false;
        }

        public Object[] getElements(Object element) {
            return this.fContent.getHeadings(null).toArray();
        }

        public boolean hasChildren(Object element) {
            if (element == MarkdownContentOutlinePage.this.fInput) {
                return true;
            }
            if (element instanceof MarkdownPage.Header) {
                MarkdownPage.Header header = (MarkdownPage.Header)element;
                return header.getSubHeaders().size() > 0;
            }
            return false;
        }

        public Object getParent(Object element) {
            if (!(element instanceof MarkdownPage.Header)) {
                return null;
            }
            return ((MarkdownPage.Header)element).getParent();
        }

        public Object[] getChildren(Object element) {
            if (element == MarkdownContentOutlinePage.this.fInput) {
                return this.fContent.getHeadings(null).toArray();
            }
            if (!(element instanceof MarkdownPage.Header)) {
                return null;
            }
            return ((MarkdownPage.Header)element).getSubHeaders().toArray();
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
        }

        public void documentChanged(DocumentEvent event) {
            this.parse();
            MarkdownContentOutlinePage.this.update();
        }
    }
}

