/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.workbench.search;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.simantics.db.layer0.genericrelation.IndexQueries;

public class SearchQuery {
    private String originalQuery;
    private Map<String, String> searchFlags = new HashMap<String, String>();
    private Set<String> searchParams = new HashSet<String>();

    public SearchQuery() {
    }

    public SearchQuery(String originalQuery) {
        this.originalQuery = originalQuery;
    }

    public void setOriginalQuery(String originalQuery) {
        this.originalQuery = originalQuery;
    }

    public String getOriginalQuery() {
        return this.originalQuery;
    }

    public String getQuery(Set<String> supportedParams) {
        if (this.originalQuery.trim().isEmpty()) {
            return "";
        }
        Object query = "";
        int count = 0;
        for (String key : this.searchFlags.keySet()) {
            if (!supportedParams.contains(key) || !"on".equals(this.searchFlags.get(key))) continue;
            if (count > 0) {
                query = (String)query + " OR ";
            }
            ArrayList<CallSite> subQ = new ArrayList<CallSite>();
            String[] stringArray = this.originalQuery.split("\\\\ ", -1);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String part = stringArray[n2];
                subQ.add((CallSite)((Object)(key + ":" + part)));
                ++n2;
            }
            query = (String)query + "(";
            query = (String)query + String.join((CharSequence)" AND ", subQ);
            query = (String)query + ")";
            ++count;
        }
        return query;
    }

    public String getQuery(String ... supportedParams) {
        HashSet<String> set = new HashSet<String>();
        String[] stringArray = supportedParams;
        int n = supportedParams.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            set.add(s);
            ++n2;
        }
        return this.getQuery(set);
    }

    public void setSearchFlag(String key, String value) {
        this.searchFlags.put(key, value);
    }

    public void setSearchParam(String key) {
        this.searchParams.add(key);
    }

    public Map<String, String> getSearchFlags() {
        return Collections.unmodifiableMap(this.searchFlags);
    }

    public Set<String> getSearchParams() {
        return Collections.unmodifiableSet(this.searchParams);
    }

    public boolean getBooleanFlag(String key) {
        return "on".equals(this.searchFlags.get(key));
    }

    public boolean getBooleanParam(String key) {
        return this.searchParams.contains(key);
    }

    public String toString() {
        return this.originalQuery;
    }

    public SearchQuery withOriginalQuery(String query) {
        SearchQuery ret = new SearchQuery(query);
        ret.searchFlags = new HashMap<String, String>(this.searchFlags);
        ret.searchParams = new HashSet<String>(this.searchParams);
        return ret;
    }

    public SearchQuery escaped(boolean escapeWildcards) {
        return this.withOriginalQuery(IndexQueries.escape((String)this.originalQuery, (boolean)escapeWildcards));
    }

    public SearchQuery withForcedCase(boolean uppercase) {
        return this.withOriginalQuery(uppercase ? this.originalQuery.toUpperCase() : this.originalQuery.toLowerCase());
    }

    public SearchQuery escapedWithForcedCase(boolean uppercase, boolean escapeWildcards) {
        return this.withForcedCase(uppercase).escaped(escapeWildcards);
    }

    public static URL encode(File file, SearchQuery query) throws IOException {
        URL url = file.toURI().toURL();
        String s = url.toString() + "?search=" + URLEncoder.encode(query.getOriginalQuery(), "UTF-8");
        Map<String, String> flags = query.getSearchFlags();
        for (String key : flags.keySet()) {
            s = s + "&" + key + "=" + flags.get(key);
        }
        for (String param : query.getSearchParams()) {
            s = s + "&" + param;
        }
        url = new URL(s);
        return url;
    }

    public static SearchQuery decode(URL url) throws IOException {
        String query = url.getQuery();
        SearchQuery searchQuery = new SearchQuery();
        if (query != null) {
            String[] stringArray = query.split("&");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String arg = stringArray[n2];
                String[] keyvalue = arg.split("=");
                if ("search".equals(keyvalue[0])) {
                    if (keyvalue.length == 2) {
                        searchQuery.setOriginalQuery(URLDecoder.decode(keyvalue[1], "UTF-8"));
                    }
                } else if (keyvalue.length == 2) {
                    searchQuery.setSearchFlag(URLDecoder.decode(keyvalue[0], "UTF-8"), URLDecoder.decode(keyvalue[1], "UTF-8"));
                } else if (keyvalue.length == 1) {
                    searchQuery.setSearchParam(URLDecoder.decode(keyvalue[0], "UTF-8"));
                }
                ++n2;
            }
        }
        return searchQuery;
    }
}

