package org.simantics.views.swt;

import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;
import org.simantics.Simantics;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.request.Read;
import org.simantics.views.ontology.ViewsResources;
import org.simantics.views.swt.client.base.SWTRoot;

public class ModelledWizardPageImpl implements ModelledWizardPage {

	final private Resource configuration;
	private SWTRoot root;
	
	public ModelledWizardPageImpl(Resource configuration) {
		this.configuration = configuration;
	}
	
	@Override
	public SWTRoot getRoot() {
		return root;
	}

	class Page extends WizardPage {

		final private Resource runtime;
		
		public Page(String title, Resource runtime) {
			super(title, title, null);
			this.runtime = runtime;
		}
		
		@Override
		public void createControl(Composite parent) {

			try {

				Resource control = Simantics.getSession().sync(new UniqueRead<Resource>() {
					@Override
					public Resource perform(ReadGraph graph) throws DatabaseException {
						ViewsResources VIEW = ViewsResources.getInstance(graph);
						return graph.getPossibleObject(configuration, VIEW.Wizard_Page_Control);
					}
				});
				
				SWTViewLoaderProcess process = new SWTViewLoaderProcess(null, null);
				root = process.load(control, runtime);
				root.createControls(parent);

				setControl(root.getSingleChild());

			} catch (DatabaseException e) {
				
				e.printStackTrace();
				Logger.defaultLogError(e);
				
			}
			
		}
		
	}
	
	public IWizardPage create(ISessionContext context, WidgetSupport support, Resource runtime) throws DatabaseException {

		String title = Simantics.getSession().syncRequest(new Read<String>() {
			@Override
			public String perform(ReadGraph graph) throws DatabaseException {
				ViewsResources VIEW = ViewsResources.getInstance(graph);
				return graph.getPossibleRelatedValue(configuration, VIEW.Wizard_Page_Title, Bindings.STRING);
			}
		});

		return new Page(title, runtime);
		
	}
	
}
